/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.scm.BlameLine;

public class JGitBlameCommand {
    private static final Logger LOG = LoggerFactory.getLogger(JGitBlameCommand.class);

    public List<BlameLine> blame(Git git, String filename) {
        BlameResult blameResult;
        try {
            blameResult = git.blame().setTextComparator(RawTextComparator.WS_IGNORE_ALL).setFilePath(filename).call();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to blame file " + filename, e);
        }
        ArrayList<BlameLine> lines = new ArrayList<BlameLine>();
        if (blameResult == null) {
            LOG.debug("Unable to blame file {}. It is probably a symlink.", (Object)filename);
            return Collections.emptyList();
        }
        for (int i = 0; i < blameResult.getResultContents().size(); ++i) {
            if (blameResult.getSourceAuthor(i) == null || blameResult.getSourceCommit(i) == null) {
                LOG.debug("Unable to blame file {}. No blame info at line {}. Is file committed? [Author: {} Source commit: {}]", filename, i + 1, blameResult.getSourceAuthor(i), blameResult.getSourceCommit(i));
                return Collections.emptyList();
            }
            lines.add(new BlameLine().date(blameResult.getSourceCommitter(i).getWhen()).revision(blameResult.getSourceCommit(i).getName()).author(blameResult.getSourceAuthor(i).getEmailAddress()));
        }
        return lines;
    }
}

