/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.scm.git.blame.FileBlamer;
import org.sonar.scm.git.blame.FileCandidate;
import org.sonar.scm.git.blame.GraphNode;
import org.sonar.scm.git.blame.GraphNodeFactory;

public class BlameGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(BlameGenerator.class);
    private final TreeSet<GraphNode> queue = new TreeSet<GraphNode>(GraphNode.TIME_COMPARATOR);
    private final Repository repository;
    private final FileBlamer fileBlamer;
    private final GraphNodeFactory graphNodeFactory;
    private final RevWalk revPool;
    private final BiConsumer<Integer, String> progressCallBack;

    public BlameGenerator(Repository repository, FileBlamer fileBlamer, GraphNodeFactory graphNodeFactory, @Nullable BiConsumer<Integer, String> progressCallBack) {
        this.repository = repository;
        this.fileBlamer = fileBlamer;
        this.graphNodeFactory = graphNodeFactory;
        this.revPool = new RevWalk(repository);
        this.progressCallBack = progressCallBack;
    }

    private void prepareStartCommit(@CheckForNull ObjectId startCommit) throws IOException, NoHeadException {
        GraphNode graphNode;
        TreeWalk treeWalk = new TreeWalk(this.revPool.getObjectReader());
        if (startCommit == null) {
            RevCommit headCommit = this.revPool.parseCommit(this.getHead().toObjectId());
            graphNode = this.graphNodeFactory.createForWorkingDir(treeWalk, headCommit);
        } else {
            RevCommit startRevCommit = this.revPool.parseCommit(startCommit);
            graphNode = this.graphNodeFactory.createForCommit(treeWalk, startRevCommit);
        }
        if (!graphNode.getAllFiles().isEmpty()) {
            this.fileBlamer.initialize(this.revPool.getObjectReader(), graphNode);
            this.push(graphNode);
        }
    }

    private ObjectId getHead() throws IOException, NoHeadException {
        ObjectId head = this.repository.resolve("HEAD");
        if (head == null) {
            throw new NoHeadException(MessageFormat.format(JGitText.get().noSuchRefKnown, "HEAD"));
        }
        return head;
    }

    private void push(GraphNode newCommit) {
        if (this.queue.contains(newCommit)) {
            GraphNode existingCommit = this.queue.ceiling(newCommit);
            Map<PathAndOriginalPath, FileCandidate> newCommitFilesByPaths = newCommit.getAllFiles().stream().collect(Collectors.toMap(x$0 -> new PathAndOriginalPath((FileCandidate)x$0), f -> f));
            Map<PathAndOriginalPath, FileCandidate> existingCommitFilesByPaths = existingCommit.getAllFiles().stream().collect(Collectors.toMap(x$0 -> new PathAndOriginalPath((FileCandidate)x$0), f -> f));
            for (Map.Entry<PathAndOriginalPath, FileCandidate> newFiles : newCommitFilesByPaths.entrySet()) {
                if (existingCommitFilesByPaths.containsKey(newFiles.getKey())) {
                    existingCommitFilesByPaths.get(newFiles.getKey()).mergeRegions(newFiles.getValue());
                    continue;
                }
                existingCommit.addFile(newFiles.getValue());
            }
        } else {
            this.queue.add(newCommit);
        }
    }

    public void generateBlame(ObjectId startCommit) throws IOException, NoHeadException {
        this.prepareStartCommit(startCommit);
        int i = 1;
        while (!this.queue.isEmpty()) {
            GraphNode current = this.queue.pollFirst();
            LOG.debug("{} Processing commit {}", (Object)i, (Object)current);
            if (this.progressCallBack != null) {
                String hash = current.getCommit() == null ? ObjectId.zeroId().getName() : current.getCommit().getName();
                this.progressCallBack.accept(i, hash);
            }
            if (current.getParentCount() > 0) {
                this.process(current);
            } else {
                this.fileBlamer.saveBlameDataForFilesInCommit(current);
            }
            ++i;
        }
        this.close();
    }

    private void process(GraphNode commitCandidate) throws IOException {
        ArrayList<RevCommit> parentCommits = new ArrayList<RevCommit>(commitCandidate.getParentCount());
        for (int i = 0; i < commitCandidate.getParentCount(); ++i) {
            RevCommit parentCommit = commitCandidate.getParentCommit(i);
            this.revPool.parseHeaders(parentCommit);
            parentCommits.add(parentCommit);
        }
        List<GraphNode> parentStatefulCommits = parentCommits.size() > 1 ? this.fileBlamer.blameParents(parentCommits, commitCandidate) : List.of(this.fileBlamer.blameParent((RevCommit)parentCommits.get(0), commitCandidate));
        for (GraphNode parentStatefulCommit : parentStatefulCommits) {
            if (parentStatefulCommit.getAllFiles().isEmpty()) continue;
            this.push(parentStatefulCommit);
        }
        this.fileBlamer.saveBlameDataForFilesInCommit(commitCandidate);
    }

    private void close() {
        this.revPool.close();
        this.queue.clear();
        this.fileBlamer.close();
    }

    private static class PathAndOriginalPath {
        private final String path;
        private final String originalPath;

        private PathAndOriginalPath(FileCandidate file) {
            this(file.getPath(), file.getOriginalPath());
        }

        private PathAndOriginalPath(String path, String originalPath) {
            this.path = path;
            this.originalPath = originalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathAndOriginalPath that = (PathAndOriginalPath)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.originalPath, that.originalPath);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.originalPath);
        }
    }
}

