/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.scm.git.blame.FileCandidate;
import org.sonar.scm.git.blame.Region;

public class BlameResult {
    private final Map<String, FileBlame> fileBlameByPath = new HashMap<String, FileBlame>();

    public Collection<FileBlame> getFileBlames() {
        return this.fileBlameByPath.values();
    }

    public Map<String, FileBlame> getFileBlameByPath() {
        return this.fileBlameByPath;
    }

    public void initialize(String path, int size) {
        this.fileBlameByPath.put(path, new FileBlame(path, size));
    }

    public void saveBlameDataForFile(@Nullable String commitHash, @Nullable Date commitDate, @Nullable String authorEmail, FileCandidate fileCandidate) {
        Region currentRegion;
        while ((currentRegion = fileCandidate.getRegionList()) != null) {
            int resEnd = BlameResult.getResultEnd(currentRegion);
            FileBlame fileBlame = this.fileBlameByPath.get(fileCandidate.getOriginalPath());
            for (int resLine = currentRegion.resultStart; resLine < resEnd; ++resLine) {
                fileBlame.commitHashes[resLine] = commitHash;
                fileBlame.commitDates[resLine] = commitDate;
                fileBlame.authorEmails[resLine] = authorEmail;
            }
            fileCandidate.setRegionList(currentRegion.next);
        }
    }

    private static int getResultEnd(Region r) {
        return r.resultStart + r.length;
    }

    public static class FileBlame {
        private final String path;
        private final String[] commitHashes;
        private final Date[] commitDates;
        private final String[] authorEmails;

        public FileBlame(String path, int numberLines) {
            this.path = path;
            this.commitHashes = new String[numberLines];
            this.commitDates = new Date[numberLines];
            this.authorEmails = new String[numberLines];
        }

        public String getPath() {
            return this.path;
        }

        public String[] getCommitHashes() {
            return this.commitHashes;
        }

        public Date[] getCommitDates() {
            return this.commitDates;
        }

        public String[] getAuthorEmails() {
            return this.authorEmails;
        }

        public int lines() {
            return this.commitHashes.length;
        }
    }
}

