/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public class PluginReferentialManifestConverter {
    private PluginReferentialManifestConverter() {
    }

    public static PluginReferential fromPluginManifests(List<PluginManifest> pluginManifestList) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (PluginManifest pluginManifest : pluginManifestList) {
            Plugin plugin = Plugin.factory(pluginManifest.getKey());
            plugin.merge(pluginManifest);
            Release release2 = new Release((Artifact)plugin, pluginManifest.getVersion());
            release2.addRequiredSonarVersions(Version.create(pluginManifest.getSonarVersion()));
            release2.setDisplayVersion(pluginManifest.getDisplayVersion());
            plugin.addRelease(release2);
            plugins.add(plugin);
        }
        PluginReferential pluginReferential = PluginReferential.create(plugins);
        for (PluginManifest pluginManifest : pluginManifestList) {
            Plugin plugin = pluginReferential.findPlugin(pluginManifest.getKey());
            for (String requiresPluginKey : pluginManifest.getRequirePlugins()) {
                if (!StringUtils.isNotBlank(requiresPluginKey)) continue;
                plugin.getReleases().forEach(release -> {
                    String[] split = requiresPluginKey.split(":");
                    String requiredPluginReleaseKey = split[0];
                    String requiredMinimumReleaseVersion = split[1];
                    pluginReferential.addOutgoingDependency((Release)release, requiredPluginReleaseKey, requiredMinimumReleaseVersion);
                });
            }
        }
        return pluginReferential;
    }
}

