/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.ApacheSshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshConnection;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshHostDisposedException;

public class SshHost {
    private static final int CONNECTION_INACTIVITY_TIMEOUT = Integer.parseInt(System.getProperty("svnkit.ssh.connection.inactivity.timeout.secs", "600")) * 1000;
    private static final int MAX_CONCURRENT_OPENERS = Integer.parseInt(System.getProperty("svnkit.ssh.max.concurrent.connection.openers", "3"));
    private static final int MAX_SESSIONS_PER_CONNECTION = Integer.parseInt(System.getProperty("svnkit.ssh.max.sessions.per.connection", "8"));
    private final String hostName;
    private final int port;
    private char[] privateKey;
    private char[] privateKeyPassphrase;
    private char[] password;
    private String userName;
    private int myConnectTimeout;
    private boolean locked;
    private boolean disposed;
    private final List<SshConnection> connections = new ArrayList<SshConnection>();
    private final Object OPENER_LOCK = new Object();
    private int openersCount;
    private int readTimeout;
    private ISVNSSHHostVerifier hostVerifier;

    public SshHost(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public void setConnectionTimeout(int timeout2) {
        this.myConnectTimeout = timeout2;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setCredentials(String userName, char[] privateKey, char[] privateKeyPassphrase, char[] password) {
        this.userName = userName;
        this.privateKey = privateKey;
        this.privateKeyPassphrase = privateKeyPassphrase;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purge() {
        try {
            this.lock();
            int size = this.connections.size();
            long time = System.currentTimeMillis();
            Iterator<SshConnection> connections = this.connections.iterator();
            while (connections.hasNext()) {
                SshConnection connection = connections.next();
                if (connection.getSessionsCount() != 0) continue;
                if (this.connections.size() == 1) {
                    long timeout2 = time - connection.lastAcccessTime();
                    if (timeout2 < (long)CONNECTION_INACTIVITY_TIMEOUT) continue;
                    connection.close();
                    connections.remove();
                    continue;
                }
                connection.close();
                connections.remove();
            }
            if (this.connections.size() == 0 && size > 0) {
                this.setDisposed(true);
            }
            boolean bl = this.isDisposed();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setDisposed(boolean disposed) {
        this.disposed = disposed;
        if (disposed) {
            for (SshConnection connection : this.connections) {
                connection.close();
            }
            this.connections.clear();
        }
    }

    public String getKey() {
        String key = this.userName + ":" + this.hostName + ":" + this.port;
        if (this.privateKey != null) {
            key = key + ":" + new String(this.privateKey);
        }
        if (this.privateKeyPassphrase != null) {
            key = key + ":" + new String(this.privateKeyPassphrase);
        }
        if (this.password != null) {
            key = key + ":" + new String(this.password);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lock() {
        List<SshConnection> list = this.connections;
        synchronized (list) {
            while (this.locked) {
                try {
                    this.connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        List<SshConnection> list = this.connections;
        synchronized (list) {
            this.locked = false;
            this.connections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApacheSshSession openSession() throws IOException {
        ApacheSshSession session = this.useExistingConnection();
        if (session != null) {
            return session;
        }
        SshConnection newConnection = null;
        this.addOpener();
        try {
            session = this.useExistingConnection();
            if (session != null) {
                ApacheSshSession apacheSshSession = session;
                return apacheSshSession;
            }
            newConnection = this.openConnection();
        }
        finally {
            this.removeOpener();
        }
        if (newConnection != null) {
            this.lock();
            try {
                if (this.isDisposed()) {
                    newConnection.close();
                    throw new SshHostDisposedException();
                }
                this.connections.add(newConnection);
                ApacheSshSession apacheSshSession = newConnection.openSession();
                return apacheSshSession;
            }
            finally {
                this.unlock();
            }
        }
        throw new IOException("Cannot establish SSH connection with " + this.hostName + ":" + this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApacheSshSession useExistingConnection() throws IOException {
        this.lock();
        try {
            if (this.isDisposed()) {
                throw new SshHostDisposedException();
            }
            Iterator<SshConnection> connections = this.connections.iterator();
            while (connections.hasNext()) {
                SshConnection connection = connections.next();
                if (connection.getSessionsCount() >= MAX_SESSIONS_PER_CONNECTION) continue;
                try {
                    ApacheSshSession apacheSshSession = connection.openSession();
                    return apacheSshSession;
                }
                catch (IOException e) {
                    try {
                        if (e.getMessage() == null || !e.getMessage().contains("connection is closed")) throw e;
                        connection.close();
                        connections.remove();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpener() {
        Object object = this.OPENER_LOCK;
        synchronized (object) {
            --this.openersCount;
            this.OPENER_LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpener() {
        Object object = this.OPENER_LOCK;
        synchronized (object) {
            while (this.openersCount >= MAX_CONCURRENT_OPENERS) {
                try {
                    this.OPENER_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.openersCount;
        }
    }

    private SshConnection openConnection() throws IOException {
        try {
            return new SshConnection(this);
        }
        catch (Exception e) {
            throw new IOException("Failed to connect to " + this.toString(), e);
        }
    }

    public String toString() {
        return this.hostName + ":" + this.port;
    }

    public void setHostVerifier(ISVNSSHHostVerifier hostVerifier) {
        this.hostVerifier = hostVerifier;
    }

    public ISVNSSHHostVerifier getHostVerifier() {
        return this.hostVerifier;
    }

    public byte[] getPrivateKey() {
        if (this.privateKey != null) {
            return new String(this.privateKey).getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        if (this.password != null) {
            return new String(this.password);
        }
        return null;
    }

    public String getPrivateKeyPassphrase() {
        if (this.privateKeyPassphrase != null) {
            return new String(this.privateKeyPassphrase);
        }
        return null;
    }
}

