/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.core.RefCounted;

public abstract class AbstractRefCounted
implements RefCounted {
    public static final String ALREADY_CLOSED_MESSAGE = "already closed, can't increment ref count";
    private final AtomicInteger refCount = new AtomicInteger(1);

    protected AbstractRefCounted() {
    }

    @Override
    public final void incRef() {
        if (!this.tryIncRef()) {
            this.alreadyClosed();
        }
    }

    @Override
    public final boolean tryIncRef() {
        int i;
        while ((i = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(i, i + 1)) continue;
            this.touch();
            return true;
        }
        return false;
    }

    @Override
    public final boolean decRef() {
        this.touch();
        int i = this.refCount.decrementAndGet();
        assert (i >= 0) : "invalid decRef call: already closed";
        if (i == 0) {
            try {
                this.closeInternal();
            }
            catch (Exception e) {
                assert (false) : e;
                throw e;
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasReferences() {
        return this.refCount.get() > 0;
    }

    protected void touch() {
    }

    protected void alreadyClosed() {
        int currentRefCount = this.refCount.get();
        assert (currentRefCount == 0) : currentRefCount;
        throw new IllegalStateException(ALREADY_CLOSED_MESSAGE);
    }

    public final int refCount() {
        return this.refCount.get();
    }

    protected abstract void closeInternal();

    public static AbstractRefCounted of(final Runnable onClose) {
        Objects.requireNonNull(onClose);
        return new AbstractRefCounted(){

            @Override
            protected void closeInternal() {
                onClose.run();
            }

            public String toString() {
                return "refCounted[" + onClose + "]";
            }
        };
    }
}

