/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ListenableActionFuture;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.reindex.BulkIndexByScrollResponseContentListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.LoggingTaskListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractBaseReindexRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends ActionType<BulkByScrollResponse>>
extends BaseRestHandler {
    private final A action;

    protected AbstractBaseReindexRestHandler(A action) {
        this.action = action;
    }

    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, NodeClient client, boolean includeCreated, boolean includeUpdated) throws IOException {
        Request internal = this.setCommonOptions(request, this.buildRequest(request, client.getNamedWriteableRegistry()));
        if (request.paramAsBoolean("wait_for_completion", true)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("include_created", Boolean.toString(includeCreated));
            params.put("include_updated", Boolean.toString(includeUpdated));
            return channel -> client.executeLocally(this.action, (ActionRequest)internal, (ActionListener)new BulkIndexByScrollResponseContentListener((RestChannel)channel, (Map<String, String>)params));
        }
        internal.setShouldStoreResult(true);
        ActionRequestValidationException validationException = internal.validate();
        if (validationException != null) {
            throw validationException;
        }
        ListenableActionFuture responseFuture = new ListenableActionFuture();
        Task task = client.executeLocally(this.action, internal, (ActionListener)responseFuture);
        responseFuture.addListener((ActionListener)new LoggingTaskListener(task));
        return this.sendTask(client.getLocalNodeId(), task);
    }

    protected abstract Request buildRequest(RestRequest var1, NamedWriteableRegistry var2) throws IOException;

    protected Request setCommonOptions(RestRequest restRequest, Request request) {
        Float requestsPerSecond;
        String waitForActiveShards;
        assert (restRequest != null) : "RestRequest should not be null";
        assert (request != null) : "Request should not be null";
        request.setRefresh(restRequest.paramAsBoolean("refresh", request.isRefresh()));
        request.setTimeout(restRequest.paramAsTime("timeout", request.getTimeout()));
        Integer slices = AbstractBaseReindexRestHandler.parseSlices(restRequest);
        if (slices != null) {
            request.setSlices(slices.intValue());
        }
        if ((waitForActiveShards = restRequest.param("wait_for_active_shards")) != null) {
            request.setWaitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        if ((requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(restRequest)) != null) {
            request.setRequestsPerSecond(requestsPerSecond.floatValue());
        }
        if (restRequest.hasParam("max_docs")) {
            AbstractBaseReindexRestHandler.setMaxDocsValidateIdentical(request, restRequest.paramAsInt("max_docs", -1));
        }
        return request;
    }

    private BaseRestHandler.RestChannelConsumer sendTask(String localNodeId, Task task) {
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", localNodeId + ":" + task.getId());
                builder.endObject();
                channel.sendResponse(new RestResponse(RestStatus.OK, builder));
            }
        };
    }

    private static Integer parseSlices(RestRequest request) {
        int slices;
        String slicesString = request.param("slices");
        if (slicesString == null) {
            return null;
        }
        if (slicesString.equals("auto")) {
            return 0;
        }
        try {
            slices = Integer.parseInt(slicesString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("[slices] must be a positive integer or the string \"auto\", but was [" + slicesString + "]", e);
        }
        if (slices < 1) {
            throw new IllegalArgumentException("[slices] must be a positive integer or the string \"auto\", but was [" + slicesString + "]");
        }
        return slices;
    }

    public static Float parseRequestsPerSecond(RestRequest request) {
        float requestsPerSecond;
        String requestsPerSecondString = request.param("requests_per_second");
        if (requestsPerSecondString == null) {
            return null;
        }
        try {
            requestsPerSecond = Float.parseFloat(requestsPerSecondString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("[requests_per_second] must be a float greater than 0. Use -1 to disable throttling.", e);
        }
        if (requestsPerSecond == -1.0f) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("[requests_per_second] must be a float greater than 0. Use -1 to disable throttling.");
        }
        return Float.valueOf(requestsPerSecond);
    }

    static void setMaxDocsValidateIdentical(AbstractBulkByScrollRequest<?> request, int maxDocs) {
        if (request.getMaxDocs() != -1 && request.getMaxDocs() != maxDocs) {
            throw new IllegalArgumentException("[max_docs] set to two different values [" + request.getMaxDocs() + "] and [" + maxDocs + "]");
        }
        request.setMaxDocs(maxDocs);
    }
}

