/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.reindex.RethrottleAction;
import org.elasticsearch.reindex.RethrottleRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.admin.cluster.RestListTasksAction;
import org.elasticsearch.tasks.TaskId;

public class RestRethrottleAction
extends BaseRestHandler {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestRethrottleAction(Supplier<DiscoveryNodes> nodesInCluster) {
        this.nodesInCluster = nodesInCluster;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_update_by_query/{taskId}/_rethrottle"), new RestHandler.Route(RestRequest.Method.POST, "/_delete_by_query/{taskId}/_rethrottle"), new RestHandler.Route(RestRequest.Method.POST, "/_reindex/{taskId}/_rethrottle"));
    }

    public String getName() {
        return "rethrottle_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        RethrottleRequest internalRequest = new RethrottleRequest();
        internalRequest.setTargetTaskId(new TaskId(request.param("taskId")));
        Float requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(request);
        if (requestsPerSecond == null) {
            throw new IllegalArgumentException("requests_per_second is a required parameter");
        }
        internalRequest.setRequestsPerSecond(requestsPerSecond.floatValue());
        String groupBy = request.param("group_by", "nodes");
        return channel -> client.execute((ActionType)RethrottleAction.INSTANCE, (ActionRequest)internalRequest, RestListTasksAction.listTasksResponseListener(this.nodesInCluster, (String)groupBy, (RestChannel)channel));
    }
}

