/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.LeaderBulkByScrollTaskState;
import org.elasticsearch.reindex.RethrottleAction;
import org.elasticsearch.reindex.RethrottleRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.TransportService;

public class TransportRethrottleAction
extends TransportTasksAction<BulkByScrollTask, RethrottleRequest, ListTasksResponse, TaskInfo> {
    private final Client client;

    @Inject
    public TransportRethrottleAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/reindex/rethrottle", clusterService, transportService, actionFilters, RethrottleRequest::new, ListTasksResponse::new, TaskInfo::from, "management");
        this.client = client;
    }

    protected void taskOperation(Task actionTask, RethrottleRequest request, BulkByScrollTask task, ActionListener<TaskInfo> listener) {
        TransportRethrottleAction.rethrottle(this.logger, this.clusterService.localNode().getId(), this.client, task, request.getRequestsPerSecond(), listener);
    }

    static void rethrottle(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        if (task.isWorker()) {
            TransportRethrottleAction.rethrottleChildTask(logger, localNodeId, task, newRequestsPerSecond, listener);
            return;
        }
        if (task.isLeader()) {
            TransportRethrottleAction.rethrottleParentTask(logger, localNodeId, client, task, newRequestsPerSecond, listener);
            return;
        }
        throw new IllegalArgumentException("task [" + task.getId() + "] has not yet been initialized to the point where it knows how to rethrottle itself");
    }

    private static void rethrottleParentTask(Logger logger, String localNodeId, Client client, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        LeaderBulkByScrollTaskState leaderState = task.getLeaderState();
        int runningSubtasks = leaderState.runningSliceSubTasks();
        if (runningSubtasks > 0) {
            RethrottleRequest subRequest = new RethrottleRequest();
            subRequest.setRequestsPerSecond(newRequestsPerSecond / (float)runningSubtasks);
            subRequest.setTargetParentTaskId(new TaskId(localNodeId, task.getId()));
            logger.debug("rethrottling children of task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(subRequest.getRequestsPerSecond()));
            client.execute((ActionType)RethrottleAction.INSTANCE, (ActionRequest)subRequest, ActionListener.wrap(r -> {
                r.rethrowFailures("Rethrottle");
                listener.onResponse((Object)task.taskInfoGivenSubtaskInfo(localNodeId, r.getTasks()));
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            logger.debug("children of task [{}] are already finished, nothing to rethrottle", (Object)task.getId());
            listener.onResponse((Object)task.taskInfo(localNodeId, true));
        }
    }

    private static void rethrottleChildTask(Logger logger, String localNodeId, BulkByScrollTask task, float newRequestsPerSecond, ActionListener<TaskInfo> listener) {
        logger.debug("rethrottling local task [{}] to [{}] requests per second", (Object)task.getId(), (Object)Float.valueOf(newRequestsPerSecond));
        task.getWorkerState().rethrottle(newRequestsPerSecond);
        listener.onResponse((Object)task.taskInfo(localNodeId, true));
    }

    protected ListTasksResponse newResponse(RethrottleRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }
}

