/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.aggregatemetric.fielddata.IndexAggregateDoubleMetricFieldData;
import org.elasticsearch.xpack.aggregatemetric.fielddata.LeafAggregateDoubleMetricFieldData;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;

public class AggregateMetricsValuesSource {

    public static abstract class AggregateDoubleMetric
    extends ValuesSource {
        public abstract SortedNumericDoubleValues getAggregateMetricValues(LeafReaderContext var1, AggregateDoubleMetricFieldMapper.Metric var2) throws IOException;

        public static class Fielddata
        extends AggregateDoubleMetric {
            protected final IndexAggregateDoubleMetricFieldData indexFieldData;

            public Fielddata(IndexAggregateDoubleMetricFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafAggregateDoubleMetricFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
                final SortedNumericDoubleValues values = this.getAggregateMetricValues(context, null);
                return new DocValueBits(){

                    public boolean advanceExact(int doc) throws IOException {
                        return values.advanceExact(doc);
                    }
                };
            }

            protected Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
                throw new AggregationExecutionException("Can't round an [aggregate_metric_double]");
            }

            @Override
            public SortedNumericDoubleValues getAggregateMetricValues(LeafReaderContext context, AggregateDoubleMetricFieldMapper.Metric metric) throws IOException {
                return ((LeafAggregateDoubleMetricFieldData)this.indexFieldData.load(context)).getAggregateMetricValues(metric);
            }
        }
    }
}

