/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.support;

import java.util.Locale;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.UnsupportedAggregationOnDownsampledIndex;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.fielddata.IndexAggregateDoubleMetricFieldData;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AggregateMetricsValuesSourceType implements ValuesSourceType
{
    AGGREGATE_METRIC{

        public RuntimeException getUnregisteredException(String message) {
            return new UnsupportedAggregationOnDownsampledIndex(message);
        }

        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped AggregateMetricsValuesSource type " + this.value());
        }

        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw new AggregationExecutionException("Value source of type [" + this.value() + "] is not supported by scripts");
        }

        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData indexFieldData = fieldContext.indexFieldData();
            if (!(indexFieldData instanceof IndexAggregateDoubleMetricFieldData)) {
                throw new IllegalArgumentException("Expected aggregate_metric_double type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new AggregateMetricsValuesSource.AggregateDoubleMetric.Fielddata((IndexAggregateDoubleMetricFieldData)indexFieldData);
        }

        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, AggregationContext context) {
            throw new IllegalArgumentException("Can't apply missing values on a " + valuesSource.getClass());
        }
    };


    public String typeName() {
        return this.value();
    }

    public static ValuesSourceType fromString(String name) {
        return AggregateMetricsValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

