/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.HashSet;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1153")
public class ConcatenationWithStringValueOfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(Tree.Kind.PLUS)) {
            super.visitBinaryExpression(tree);
            return;
        }
        HashSet<ExpressionTree> valueOfTrees = new HashSet<ExpressionTree>();
        boolean flagIssue = false;
        ExpressionTree current = tree;
        while (current.is(Tree.Kind.PLUS)) {
            BinaryExpressionTree binOp = current;
            this.scan(binOp.rightOperand());
            if (ConcatenationWithStringValueOfCheck.isStringValueOf(binOp.rightOperand())) {
                valueOfTrees.add(binOp.rightOperand());
            }
            flagIssue |= binOp.leftOperand().is(Tree.Kind.STRING_LITERAL);
            if (!valueOfTrees.isEmpty()) {
                flagIssue |= binOp.rightOperand().is(Tree.Kind.STRING_LITERAL);
            }
            current = current.leftOperand();
        }
        if (flagIssue) {
            for (ExpressionTree valueOfTree : valueOfTrees) {
                this.context.reportIssue(this, valueOfTree, "Directly append the argument of String.valueOf().");
            }
        }
        this.scan(current);
    }

    private static boolean isStringValueOf(ExpressionTree tree) {
        return tree.is(Tree.Kind.METHOD_INVOCATION) && ConcatenationWithStringValueOfCheck.isStringValueOf((MethodInvocationTree)tree);
    }

    private static boolean isStringValueOf(MethodInvocationTree tree) {
        return tree.methodSelect().is(Tree.Kind.MEMBER_SELECT) && ConcatenationWithStringValueOfCheck.isStringValueOf((MemberSelectExpressionTree)tree.methodSelect()) && ConcatenationWithStringValueOfCheck.matchArgument(tree.arguments());
    }

    private static boolean matchArgument(Arguments args) {
        return args.size() == 1 && !((ExpressionTree)args.get(0)).symbolType().isUnknown() && !((ExpressionTree)args.get(0)).symbolType().is("char[]");
    }

    private static boolean isStringValueOf(MemberSelectExpressionTree tree) {
        return tree.expression().is(Tree.Kind.IDENTIFIER) && "valueOf".equals(tree.identifier().name()) && "String".equals(((IdentifierTree)tree.expression()).name());
    }
}

