/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2972")
public class InnerClassTooManyLinesCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 25;
    @RuleProperty(key="Max", description="The maximum number of lines allowed", defaultValue="25")
    public int max = 25;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    }

    @Override
    public void visitNode(Tree tree) {
        int lines;
        ClassTree node = (ClassTree)tree;
        Symbol.TypeSymbol symbol = node.symbol();
        Symbol owner = symbol.owner();
        Type ownerType = owner.type();
        if (ownerType != null && ownerType.isClass() && owner.owner().isPackageSymbol() && (lines = new LinesOfCodeVisitor().linesOfCode(node)) > this.max) {
            this.reportIssue(ExpressionsHelper.reportOnClassTree(node), "Reduce this class from " + lines + " lines to the maximum allowed " + this.max + " or externalize it in a public class.");
        }
    }
}

