/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4517")
public class InputStreamReadCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers INPUT_STREAM_READ = MethodMatchers.create().ofSubTypes("java.io.InputStream").names("read").addWithoutParametersMatcher().build();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        if (method.block() != null && INPUT_STREAM_READ.matches(method)) {
            method.accept(new ReturnStatementVisitor());
        }
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private ReturnStatementVisitor() {
        }

        @Override
        public void visitReturnStatement(ReturnStatementTree tree) {
            ExpressionTree expression = tree.expression();
            if (expression.symbolType().is("byte")) {
                InputStreamReadCheck.this.reportIssue(expression, "Convert this signed byte into an unsigned byte.");
            }
        }

        @Override
        public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        }

        @Override
        public void visitClass(ClassTree tree) {
        }
    }
}

