/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2437")
public class SillyBitOperationCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.XOR, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.AND, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.OR, Tree.Kind.OR_ASSIGNMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        SyntaxToken operatorToken;
        ExpressionTree expression;
        if (tree.is(Tree.Kind.OR, Tree.Kind.XOR, Tree.Kind.AND)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            expression = binary.rightOperand();
            operatorToken = binary.operatorToken();
        } else {
            AssignmentExpressionTree assignment = (AssignmentExpressionTree)tree;
            expression = assignment.expression();
            operatorToken = assignment.operatorToken();
        }
        Long evaluatedExpression = LiteralUtils.longLiteralValue(expression);
        if (evaluatedExpression != null && SillyBitOperationCheck.getBitwiseOperationIdentityElement(tree).equals(evaluatedExpression)) {
            this.reportIssue(operatorToken, "Remove this silly bit operation.");
        }
    }

    private static Long getBitwiseOperationIdentityElement(Tree tree) {
        if (tree.is(Tree.Kind.AND, Tree.Kind.AND_ASSIGNMENT)) {
            return -1L;
        }
        return 0L;
    }
}

