/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3753")
public class ControllerWithSessionAttributesCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        SymbolMetadata classMetadata = classTree.symbol().metadata();
        Optional<AnnotationTree> sessionAttributesAnnotation = classTree.modifiers().annotations().stream().filter(a -> a.annotationType().symbolType().is("org.springframework.web.bind.annotation.SessionAttributes")).findFirst();
        if (sessionAttributesAnnotation.isPresent() && classMetadata.isAnnotatedWith("org.springframework.stereotype.Controller")) {
            MethodInvocationVisitor methodInvocationVisitor = new MethodInvocationVisitor();
            classTree.accept(methodInvocationVisitor);
            if (!methodInvocationVisitor.setCompleteIsCalled) {
                this.reportIssue(sessionAttributesAnnotation.get().annotationType(), "Add a call to \"setComplete()\" on the SessionStatus object in a \"@RequestMapping\" method.");
            }
        }
    }

    private static class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private static final MethodMatchers SET_COMPLETE = MethodMatchers.create().ofTypes("org.springframework.web.bind.support.SessionStatus").names("setComplete").withAnyParameters().build();
        boolean setCompleteIsCalled;

        private MethodInvocationVisitor() {
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree methodInvocationTree) {
            if (SET_COMPLETE.matches(methodInvocationTree)) {
                this.setCompleteIsCalled = true;
            }
        }
    }
}

