/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven;

import java.util.Collections;
import java.util.Optional;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3422")
public class DependencyWithSystemScopeCheck
extends SimpleXPathBasedCheck {
    private XPathExpression dependencyExpression = this.getXPathExpression("//dependencies/dependency");

    @Override
    public void scanFile(XmlFile xmlFile) {
        if (!"pom.xml".equalsIgnoreCase(xmlFile.getInputFile().filename())) {
            return;
        }
        this.evaluateAsList(this.dependencyExpression, xmlFile.getNamespaceUnawareDocument()).forEach(dependency -> this.checkDependency((Element)dependency));
    }

    private void checkDependency(Element dependency) {
        Optional<Node> scope = DependencyWithSystemScopeCheck.getElementByName("scope", dependency);
        if (!scope.isPresent() || !"system".equalsIgnoreCase(scope.get().getTextContent())) {
            return;
        }
        Optional<Node> systemPathOptional = DependencyWithSystemScopeCheck.getElementByName("systemPath", dependency);
        if (systemPathOptional.isPresent()) {
            this.reportIssue(XmlFile.nodeLocation(scope.get()), "Update this scope and remove the \"systemPath\".", Collections.singletonList(new SonarXmlCheck.Secondary(systemPathOptional.get(), "Remove this")));
        } else {
            this.reportIssue(scope.get(), "Update this scope.");
        }
    }

    private static Optional<Node> getElementByName(String name, Element nestingElement) {
        NodeList nodeList = nestingElement.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            return Optional.of(nodeList.item(0));
        }
        return Optional.empty();
    }
}

