/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.Preconditions;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameterTree;

public class TypeParameterTreeImpl
extends JavaTree
implements TypeParameterTree {
    private IdentifierTreeImpl identifier;
    @Nullable
    private final SyntaxToken extendsToken;
    private final BoundListTreeImpl bounds;
    @Nullable
    ITypeBinding typeBinding;

    public TypeParameterTreeImpl(IdentifierTreeImpl identifier) {
        this.identifier = identifier;
        this.extendsToken = null;
        this.bounds = BoundListTreeImpl.emptyList();
    }

    public TypeParameterTreeImpl(InternalSyntaxToken extendsToken, BoundListTreeImpl bounds) {
        this.extendsToken = extendsToken;
        this.bounds = bounds;
    }

    public TypeParameterTreeImpl complete(IdentifierTreeImpl identifier) {
        Preconditions.checkState(this.identifier == null);
        this.identifier = identifier;
        return this;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParameter(this);
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public SyntaxToken extendToken() {
        return this.extendsToken;
    }

    @Override
    public ListTree<Tree> bounds() {
        return this.bounds;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TYPE_PARAMETER;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        list.add(this.identifier);
        if (this.extendsToken != null) {
            list.add(this.extendsToken);
            list.add(this.bounds);
        }
        return Collections.unmodifiableList(list);
    }

    public Symbol symbol() {
        return this.typeBinding != null ? this.root.sema.typeSymbol(this.typeBinding) : Symbols.unknownSymbol;
    }
}

