/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.sonar.java.Preconditions;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.model.Symbols;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class MethodTreeImpl
extends JavaTree
implements MethodTree {
    private ModifiersTree modifiers;
    private TypeParameters typeParameters = new TypeParameterListTreeImpl();
    @Nullable
    private TypeTree returnType;
    private IdentifierTree simpleName;
    @Nullable
    private final SyntaxToken openParenToken;
    private final FormalParametersListTreeImpl parameters;
    @Nullable
    private final SyntaxToken closeParenToken;
    @Nullable
    private final BlockTree block;
    @Nullable
    private SyntaxToken semicolonToken;
    @Nullable
    private final SyntaxToken throwsToken;
    private final ListTree<TypeTree> throwsClauses;
    private final SyntaxToken defaultToken;
    private final ExpressionTree defaultValue;
    @Nullable
    private CFG cfg;
    @Nullable
    public IMethodBinding methodBinding;

    public MethodTreeImpl(FormalParametersListTreeImpl parameters, @Nullable SyntaxToken defaultToken, @Nullable ExpressionTree defaultValue) {
        this.parameters = parameters;
        this.openParenToken = parameters.openParenToken();
        this.closeParenToken = parameters.closeParenToken();
        this.block = null;
        this.throwsToken = null;
        this.throwsClauses = QualifiedIdentifierListTreeImpl.emptyList();
        this.defaultToken = defaultToken;
        this.defaultValue = defaultValue;
    }

    public MethodTreeImpl(@Nullable TypeTree returnType, IdentifierTree simpleName, FormalParametersListTreeImpl parameters, @Nullable SyntaxToken throwsToken, ListTree<TypeTree> throwsClauses, @Nullable BlockTree block, @Nullable SyntaxToken semicolonToken) {
        this.modifiers = null;
        this.returnType = returnType;
        this.simpleName = Objects.requireNonNull(simpleName);
        this.parameters = Objects.requireNonNull(parameters);
        this.openParenToken = parameters.openParenToken();
        this.closeParenToken = parameters.closeParenToken();
        this.block = block;
        this.semicolonToken = semicolonToken;
        this.throwsToken = throwsToken;
        this.throwsClauses = Objects.requireNonNull(throwsClauses);
        this.defaultToken = null;
        this.defaultValue = null;
    }

    public MethodTreeImpl complete(TypeTree returnType, IdentifierTree simpleName, SyntaxToken semicolonToken) {
        Preconditions.checkState(this.simpleName == null);
        this.returnType = returnType;
        this.simpleName = simpleName;
        this.semicolonToken = semicolonToken;
        return this;
    }

    public MethodTreeImpl completeWithTypeParameters(TypeParameterListTreeImpl typeParameters) {
        this.typeParameters = typeParameters;
        return this;
    }

    public MethodTreeImpl completeWithModifiers(ModifiersTreeImpl modifiers) {
        Preconditions.checkState(this.modifiers == null);
        this.modifiers = modifiers;
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return this.returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public TypeParameters typeParameters() {
        return this.typeParameters;
    }

    @Override
    @Nullable
    public TypeTree returnType() {
        return this.returnType;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    @Nullable
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public List<VariableTree> parameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public SyntaxToken throwsToken() {
        return this.throwsToken;
    }

    @Override
    public ListTree<TypeTree> throwsClauses() {
        return this.throwsClauses;
    }

    @Override
    @Nullable
    public BlockTree block() {
        return this.block;
    }

    @Override
    @Nullable
    public SyntaxToken semicolonToken() {
        return this.semicolonToken;
    }

    @Override
    @Nullable
    public SyntaxToken defaultToken() {
        return this.defaultToken;
    }

    @Override
    @Nullable
    public ExpressionTree defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Symbol.MethodSymbol symbol() {
        return this.methodBinding != null ? this.root.sema.methodSymbol(this.methodBinding) : Symbols.unknownMethodSymbol;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethod(this);
    }

    @Override
    public int getLine() {
        return this.parameters.openParenToken().getLine();
    }

    @Override
    @Nullable
    public CFG cfg() {
        if (this.block == null) {
            return null;
        }
        if (this.cfg == null) {
            this.cfg = CFG.build(this);
        }
        return this.cfg;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        list.add(this.modifiers);
        list.add(this.typeParameters);
        if (this.returnType != null) {
            list.add(this.returnType);
        }
        list.add(this.simpleName);
        if (this.openParenToken != null) {
            list.add(this.openParenToken);
            list.addAll(this.parameters);
            list.add(this.closeParenToken);
        }
        if (this.throwsToken != null) {
            list.add(this.throwsToken);
            list.add(this.throwsClauses);
        }
        if (this.defaultToken != null) {
            list.add(this.defaultToken);
            list.add(this.defaultValue);
        }
        if (this.block != null) {
            list.add(this.block);
        } else {
            list.add(this.semicolonToken);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    @Nullable
    public Boolean isOverriding() {
        if (this.isStatic() || this.isPrivate()) {
            return false;
        }
        if (this.isAnnotatedOverride()) {
            return true;
        }
        List<Symbol.MethodSymbol> overriddenSymbols = this.symbol().overriddenSymbols();
        if (overriddenSymbols.isEmpty()) {
            return false;
        }
        return overriddenSymbols.stream().allMatch(Symbol::isUnknown) ? null : Boolean.valueOf(true);
    }

    private boolean isStatic() {
        return ModifiersUtils.hasModifier(this.modifiers, Modifier.STATIC);
    }

    private boolean isPrivate() {
        return ModifiersUtils.hasModifier(this.modifiers, Modifier.PRIVATE);
    }

    public boolean isAnnotatedOverride() {
        for (AnnotationTree annotationTree : this.modifiers.annotations()) {
            if (!MethodTreeImpl.isJavaLangOverride(annotationTree.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaLangOverride(TypeTree annotationType) {
        return annotationType.is(Tree.Kind.IDENTIFIER) && MethodTreeImpl.isOverride((IdentifierTree)annotationType) || annotationType.is(Tree.Kind.MEMBER_SELECT) && MethodTreeImpl.isJavaLangOverride((MemberSelectExpressionTree)annotationType);
    }

    private static boolean isJavaLangOverride(MemberSelectExpressionTree annotationType) {
        MemberSelectExpressionTree mse = annotationType;
        if (MethodTreeImpl.isOverride(mse.identifier()) && mse.expression().is(Tree.Kind.MEMBER_SELECT)) {
            return "lang".equals((mse = (MemberSelectExpressionTree)mse.expression()).identifier().name()) && mse.expression().is(Tree.Kind.IDENTIFIER) && "java".equals(((IdentifierTree)mse.expression()).name());
        }
        return false;
    }

    private static boolean isOverride(IdentifierTree id) {
        return "Override".equals(id.name());
    }
}

