/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="LinkToNothingCheck")
public class LinkToNothingCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (LinkToNothingCheck.isATag(node) && LinkToNothingCheck.hasHrefToNothing(node)) {
            this.createViolation(node, "Give this link a valid reference or remove the reference.");
        }
    }

    private static boolean isATag(TagNode node) {
        return "A".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasHrefToNothing(TagNode node) {
        String href = node.getAttribute("href");
        return href != null && LinkToNothingCheck.isPoitingToNothing(href);
    }

    private static boolean isPoitingToNothing(String target) {
        return "#".equalsIgnoreCase(target) || "JAVASCRIPT:VOID(0)".equalsIgnoreCase(target) || "JAVASCRIPT:VOID(0);".equalsIgnoreCase(target);
    }
}

