/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.filter.MergedPointRangeQuery;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class FiltersAggregator
extends BucketsAggregator {
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    public static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    public static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    private final String[] keys;
    private final boolean keyed;
    protected final String otherBucketKey;

    public static FiltersAggregator build(String name, AggregatorFactories factories, String[] keys, Query[] filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        FilterByFilter filterOrder = FiltersAggregator.buildFilterOrderOrNull(name, factories, keys, filters, keyed, otherBucketKey, context, parent, cardinality, metadata);
        if (filterOrder != null) {
            return filterOrder;
        }
        return new Compatible(name, factories, keys, filters, keyed, otherBucketKey, context, parent, cardinality, metadata);
    }

    public static FilterByFilter buildFilterOrderOrNull(String name, AggregatorFactories factories, String[] keys, Query[] filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (parent != null) {
            return null;
        }
        if (factories.countAggregators() != 0) {
            return null;
        }
        if (otherBucketKey != null) {
            return null;
        }
        return new FilterByFilter(name, keys, filters, keyed, context, parent, cardinality, metadata);
    }

    private FiltersAggregator(String name, AggregatorFactories factories, String[] keys, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality.multiply(keys.length + (otherBucketKey == null ? 0 : 1)), metadata);
        this.keyed = keyed;
        this.keys = keys;
        this.otherBucketKey = otherBucketKey;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.keys.length + (this.otherBucketKey == null ? 0 : 1), (offsetInOwningOrd, docCount, subAggregationResults) -> {
            if (offsetInOwningOrd < this.keys.length) {
                return new InternalFilters.InternalBucket(this.keys[offsetInOwningOrd], docCount, subAggregationResults, this.keyed);
            }
            return new InternalFilters.InternalBucket(this.otherBucketKey, docCount, subAggregationResults, this.keyed);
        }, buckets -> new InternalFilters(this.name, (List<InternalFilters.InternalBucket>)buckets, this.keyed, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.InternalBucket> buckets = new ArrayList<InternalFilters.InternalBucket>(this.keys.length);
        for (int i = 0; i < this.keys.length; ++i) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.keys[i], 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        if (this.otherBucketKey != null) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.otherBucketKey, 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.metadata());
    }

    protected Weight[] buildWeights(Query topLevelQuery, Query[] filters) throws IOException {
        Weight[] weights = new Weight[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            Query filter = FiltersAggregator.filterMatchingBoth(topLevelQuery, filters[i]);
            weights[i] = this.searcher().createWeight(this.searcher().rewrite(filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return weights;
    }

    static Query filterMatchingBoth(Query lhs, Query rhs) {
        Query merged;
        if (lhs instanceof MatchAllDocsQuery) {
            return rhs;
        }
        if (rhs instanceof MatchAllDocsQuery) {
            return lhs;
        }
        Query unwrappedLhs = FiltersAggregator.unwrap(lhs);
        Query unwrappedRhs = FiltersAggregator.unwrap(rhs);
        if (unwrappedLhs instanceof PointRangeQuery && unwrappedRhs instanceof PointRangeQuery && (merged = MergedPointRangeQuery.merge((PointRangeQuery)unwrappedLhs, (PointRangeQuery)unwrappedRhs)) != null) {
            return merged;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(lhs, BooleanClause.Occur.MUST);
        builder.add(rhs, BooleanClause.Occur.MUST);
        return builder.build();
    }

    private static Query unwrap(Query query) {
        if (query instanceof IndexSortSortedNumericDocValuesRangeQuery) {
            query = ((IndexSortSortedNumericDocValuesRangeQuery)query).getFallbackQuery();
        }
        if (query instanceof IndexOrDocValuesQuery) {
            query = ((IndexOrDocValuesQuery)query).getIndexQuery();
        }
        return query;
    }

    public static class FilterByFilter
    extends FiltersAggregator {
        private final Query[] filters;
        private final boolean profiling;
        private long estimatedCost = -1L;
        private long maxCost = -1L;
        private long estimateCostTime;
        private Weight[] weights;
        private BulkScorer[][] scorers;
        private int segmentsWithDeletedDocs;
        private int segmentsWithDocCount;

        private FilterByFilter(String name, String[] keys, Query[] filters, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, AggregatorFactories.EMPTY, keys, keyed, null, context, parent, cardinality, metadata);
            this.filters = filters;
            this.profiling = context.profiling();
        }

        public long estimateCost(long maxCost) throws IOException {
            this.maxCost = maxCost;
            if (this.estimatedCost != -1L) {
                return this.estimatedCost;
            }
            long limit = this.profiling ? Long.MAX_VALUE : maxCost;
            long start = this.profiling ? System.nanoTime() : 0L;
            this.estimatedCost = 0L;
            this.weights = this.buildWeights(this.topLevelQuery(), this.filters);
            List leaves = this.searcher().getIndexReader().leaves();
            this.scorers = new BulkScorer[leaves.size()][];
            for (LeafReaderContext ctx : leaves) {
                this.scorers[ctx.ord] = new BulkScorer[this.filters.length];
                for (int f = 0; f < this.filters.length; ++f) {
                    this.scorers[ctx.ord][f] = this.weights[f].bulkScorer(ctx);
                    if (this.scorers[ctx.ord][f] == null || this.estimatedCost < 0L || this.estimatedCost > limit) continue;
                    this.estimatedCost += this.scorers[ctx.ord][f].cost();
                }
            }
            if (this.profiling) {
                this.estimateCostTime = System.nanoTime() - start;
            }
            return this.estimatedCost < 0L ? Long.MAX_VALUE : this.estimatedCost;
        }

        boolean scorersCached() {
            return this.scorers != null;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
            if (this.weights == null) {
                this.weights = this.buildWeights(this.topLevelQuery(), this.filters);
            }
            Bits live = ctx.reader().getLiveDocs();
            Counter counter = new Counter(this.docCountProvider);
            if (!this.docCountProvider.alwaysOne()) {
                ++this.segmentsWithDocCount;
            }
            for (int filterOrd = 0; filterOrd < this.filters.length; ++filterOrd) {
                BulkScorer scorer = this.scorers == null ? this.weights[filterOrd].bulkScorer(ctx) : this.scorers[ctx.ord][filterOrd];
                if (scorer == null) continue;
                scorer.score((LeafCollector)counter, live);
                this.incrementBucketDocCount(filterOrd, counter.readAndReset(ctx));
            }
            throw new CollectionTerminatedException();
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("segments_with_deleted_docs", this.segmentsWithDeletedDocs);
            add.accept("segments_with_doc_count", this.segmentsWithDocCount);
            if (this.estimatedCost != -1L) {
                add.accept("estimated_cost", this.estimatedCost);
                add.accept("max_cost", this.maxCost);
                add.accept("estimate_cost_time", this.estimateCostTime);
            }
        }

        private static class Counter
        implements LeafCollector {
            private final DocCountProvider docCount;
            private long count;

            Counter(DocCountProvider docCount) {
                this.docCount = docCount;
            }

            public long readAndReset(LeafReaderContext ctx) throws IOException {
                long result = this.count;
                this.count = 0L;
                this.docCount.setLeafReaderContext(ctx);
                return result;
            }

            public void collect(int doc) throws IOException {
                this.count += (long)this.docCount.getDocCount(doc);
            }

            public void setScorer(Scorable scorer) throws IOException {
            }
        }
    }

    private static class Compatible
    extends FiltersAggregator {
        private final Query[] filters;
        private Weight[] filterWeights;
        private final int totalNumKeys;

        Compatible(String name, AggregatorFactories factories, String[] keys, Query[] filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, keys, keyed, otherBucketKey, context, parent, cardinality, metadata);
            this.filters = filters;
            this.totalNumKeys = otherBucketKey == null ? keys.length : keys.length + 1;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
            if (this.filterWeights == null) {
                this.filterWeights = this.buildWeights((Query)new MatchAllDocsQuery(), this.filters);
            }
            final Bits[] bits = new Bits[this.filters.length];
            for (int i = 0; i < this.filters.length; ++i) {
                bits[i] = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filterWeights[i].scorerSupplier(ctx));
            }
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    boolean matched = false;
                    for (int i = 0; i < bits.length; ++i) {
                        if (!bits[i].get(doc)) continue;
                        this.collectBucket(sub, doc, this.bucketOrd(bucket, i));
                        matched = true;
                    }
                    if (otherBucketKey != null && !matched) {
                        this.collectBucket(sub, doc, this.bucketOrd(bucket, bits.length));
                    }
                }
            };
        }

        final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
            return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
        }
    }

    public static class KeyedFilter
    implements Writeable,
    ToXContentFragment {
        private final String key;
        private final QueryBuilder filter;

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = in.readNamedWriteable(QueryBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable(this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, (ToXContent)this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

