/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.bandit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.ExternalIssuesSensor;
import org.sonar.plugins.python.bandit.BanditJsonReportReader;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class BanditSensor
extends ExternalIssuesSensor {
    private static final Logger LOG = Loggers.get(BanditSensor.class);
    public static final String LINTER_NAME = "Bandit";
    public static final String LINTER_KEY = "bandit";
    public static final String REPORT_PATH_KEY = "sonar.python.bandit.reportPaths";
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;

    @Override
    protected void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) throws IOException, ParseException {
        FileInputStream in = new FileInputStream(reportPath);
        LOG.info("Importing {}", (Object)reportPath);
        BanditJsonReportReader.read(in, issue -> BanditSensor.saveIssue(context, issue, unresolvedInputFiles));
    }

    private static void saveIssue(SensorContext context, BanditJsonReportReader.Issue issue, Set<String> unresolvedInputFiles) {
        if (StringUtils.isEmpty(issue.ruleKey) || StringUtils.isEmpty(issue.filePath) || StringUtils.isEmpty(issue.message)) {
            LOG.debug("Missing information for ruleKey:'{}', filePath:'{}', message:'{}'", new Object[]{issue.ruleKey, issue.filePath, issue.message});
            return;
        }
        InputFile inputFile = context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(issue.filePath));
        if (inputFile == null) {
            unresolvedInputFiles.add(issue.filePath);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        newExternalIssue.type(RuleType.VULNERABILITY).severity(BanditSensor.toSonarQubeSeverity(issue.severity, issue.confidence)).remediationEffortMinutes(DEFAULT_CONSTANT_DEBT_MINUTES);
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        if (issue.lineNumber != null) {
            primaryLocation.at(inputFile.selectLine(issue.lineNumber.intValue()));
        }
        newExternalIssue.at(primaryLocation);
        newExternalIssue.engineId(LINTER_KEY);
        newExternalIssue.ruleId(issue.ruleKey).save();
    }

    private static Severity toSonarQubeSeverity(String severity, String confidence) {
        if ("HIGH".equalsIgnoreCase(severity)) {
            return "HIGH".equalsIgnoreCase(confidence) ? Severity.BLOCKER : Severity.CRITICAL;
        }
        if ("MEDIUM".equalsIgnoreCase(severity)) {
            return Severity.MAJOR;
        }
        return Severity.MINOR;
    }

    @Override
    protected boolean shouldExecute(Configuration conf) {
        return conf.hasKey(REPORT_PATH_KEY);
    }

    @Override
    protected String linterName() {
        return LINTER_NAME;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected Logger logger() {
        return LOG;
    }
}

