/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.TreeUtils;

public class ProjectLevelSymbolTable {
    private final Map<String, Set<Symbol>> globalSymbolsByModuleName;
    private Map<String, Symbol> globalSymbolsByFQN;
    private final Set<String> djangoViewsFQN = new HashSet<String>();

    public static ProjectLevelSymbolTable empty() {
        return new ProjectLevelSymbolTable(Collections.emptyMap());
    }

    public static ProjectLevelSymbolTable from(Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        return new ProjectLevelSymbolTable(globalSymbolsByModuleName);
    }

    public ProjectLevelSymbolTable() {
        this.globalSymbolsByModuleName = new HashMap<String, Set<Symbol>>();
    }

    private ProjectLevelSymbolTable(Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        this.globalSymbolsByModuleName = new HashMap<String, Set<Symbol>>(globalSymbolsByModuleName);
    }

    public void addModule(FileInput fileInput, String packageName, PythonFile pythonFile) {
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName, pythonFile);
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
        fileInput.accept(symbolTableBuilder);
        HashSet<SymbolImpl> globalSymbols = new HashSet<SymbolImpl>();
        for (Symbol globalVariable : fileInput.globalVariables()) {
            String fullyQualifiedVariableName = globalVariable.fullyQualifiedName();
            if (fullyQualifiedVariableName != null && !fullyQualifiedVariableName.startsWith(fullyQualifiedModuleName) || globalVariable.usages().stream().anyMatch(u -> u.kind().equals((Object)Usage.Kind.IMPORT))) continue;
            if (globalVariable.kind() == Symbol.Kind.CLASS) {
                globalSymbols.add(((ClassSymbolImpl)globalVariable).copyWithoutUsages());
                continue;
            }
            if (globalVariable.kind() == Symbol.Kind.FUNCTION) {
                globalSymbols.add(new FunctionSymbolImpl(globalVariable.name(), (FunctionSymbol)globalVariable));
                continue;
            }
            globalSymbols.add(new SymbolImpl(globalVariable.name(), fullyQualifiedModuleName + "." + globalVariable.name(), globalVariable.annotatedTypeName()));
        }
        this.globalSymbolsByModuleName.put(fullyQualifiedModuleName, globalSymbols);
        DjangoViewsVisitor djangoViewsVisitor = new DjangoViewsVisitor();
        fileInput.accept(djangoViewsVisitor);
    }

    private Map<String, Symbol> globalSymbolsByFQN() {
        if (this.globalSymbolsByFQN == null) {
            this.globalSymbolsByFQN = this.globalSymbolsByModuleName.values().stream().flatMap(Collection::stream).filter(symbol -> symbol.fullyQualifiedName() != null).collect(Collectors.toMap(Symbol::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousSymbolImpl.create(xva$0, xva$1)));
        }
        return this.globalSymbolsByFQN;
    }

    @CheckForNull
    public Symbol getSymbol(@Nullable String fullyQualifiedName) {
        return this.globalSymbolsByFQN().get(fullyQualifiedName);
    }

    @CheckForNull
    public Set<Symbol> getSymbolsFromModule(@Nullable String moduleName) {
        return this.globalSymbolsByModuleName.get(moduleName);
    }

    public boolean isDjangoView(@Nullable String fqn) {
        return this.djangoViewsFQN.contains(fqn);
    }

    private class DjangoViewsVisitor
    extends BaseTreeVisitor {
        private DjangoViewsVisitor() {
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            RegularArgument viewArgument;
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol == null) {
                return;
            }
            if ("django.urls.conf.path".equals(calleeSymbol.fullyQualifiedName()) && (viewArgument = TreeUtils.nthArgumentOrKeyword(1, "view", callExpression.arguments())) != null) {
                TreeUtils.getSymbolFromTree(viewArgument.expression()).filter(symbol -> symbol.fullyQualifiedName() != null).ifPresent(symbol -> ProjectLevelSymbolTable.this.djangoViewsFQN.add(symbol.fullyQualifiedName()));
            }
        }
    }
}

