/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class YieldStatementImpl
extends SimpleStatement
implements YieldStatement {
    private final YieldExpression yieldExpression;
    private final Separators separators;

    public YieldStatementImpl(YieldExpression yieldExpression, Separators separators) {
        this.yieldExpression = yieldExpression;
        this.separators = separators;
    }

    @Override
    public YieldExpression yieldExpression() {
        return this.yieldExpression;
    }

    @Override
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.YIELD_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitYieldStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.yieldExpression), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

