/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;

public abstract class AbstractInternalTerms<A extends AbstractInternalTerms<A, B>, B extends AbstractTermsBucket>
extends InternalMultiBucketAggregation<A, B> {
    public AbstractInternalTerms(String name, Map<String, Object> metadata) {
        super(name, metadata);
    }

    protected AbstractInternalTerms(StreamInput in) throws IOException {
        super(in);
    }

    protected abstract B[] createBucketsArray(int var1);

    protected abstract A create(String var1, List<B> var2, BucketOrder var3, long var4, long var6);

    protected abstract int getShardSize();

    protected abstract BucketOrder getReduceOrder();

    protected abstract BucketOrder getOrder();

    protected abstract long getSumOfOtherDocCounts();

    protected abstract long getDocCountError();

    protected abstract void setDocCountError(long var1);

    protected abstract long getMinDocCount();

    protected abstract int getRequiredSize();

    protected abstract B createBucket(long var1, InternalAggregations var3, long var4, B var6);

    @Override
    public B reduceBucket(List<B> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        long docCount = 0L;
        long docCountError = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (AbstractTermsBucket bucket : buckets) {
            docCount += bucket.getDocCount();
            if (docCountError != -1L) {
                docCountError = !bucket.getShowDocCountError() || bucket.getDocCountError() == -1L ? -1L : (docCountError += bucket.getDocCountError());
            }
            aggregationsList.add((InternalAggregations)bucket.getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(docCount, aggs, docCountError, (AbstractTermsBucket)buckets.get(0));
    }

    private BucketOrder getReduceOrder(List<InternalAggregation> aggregations) {
        BucketOrder thisReduceOrder = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (terms.getBuckets().size() == 0) continue;
            if (thisReduceOrder == null) {
                thisReduceOrder = terms.getReduceOrder();
                continue;
            }
            if (thisReduceOrder.equals(terms.getReduceOrder())) continue;
            return this.getOrder();
        }
        return thisReduceOrder != null ? thisReduceOrder : this.getOrder();
    }

    private long getDocCountError(A terms) {
        int size = ((InternalMultiBucketAggregation)terms).getBuckets().size();
        if (size == 0 || size < ((AbstractInternalTerms)terms).getShardSize() || InternalOrder.isKeyOrder(((AbstractInternalTerms)terms).getOrder())) {
            return 0L;
        }
        if (InternalOrder.isCountDesc(((AbstractInternalTerms)terms).getOrder())) {
            if (((AbstractInternalTerms)terms).getDocCountError() > 0L) {
                return ((AbstractInternalTerms)terms).getDocCountError();
            }
            return ((InternalMultiBucketAggregation)terms).getBuckets().stream().mapToLong(MultiBucketsAggregation.Bucket::getDocCount).min().getAsLong();
        }
        return -1L;
    }

    private List<B> reduceMergeSort(List<InternalAggregation> aggregations, BucketOrder thisReduceOrder, InternalAggregation.ReduceContext reduceContext) {
        assert (InternalOrder.isKeyOrder(thisReduceOrder));
        final Comparator<MultiBucketsAggregation.Bucket> cmp = thisReduceOrder.comparator();
        PriorityQueue pq = new PriorityQueue<IteratorAndCurrent<B>>(aggregations.size()){

            @Override
            protected boolean lessThan(IteratorAndCurrent<B> a, IteratorAndCurrent<B> b) {
                return cmp.compare(a.current(), b.current()) < 0;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            pq.add(new IteratorAndCurrent(terms.getBuckets().iterator()));
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> reducedBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        ArrayList<AbstractTermsBucket> currentBuckets = new ArrayList<AbstractTermsBucket>();
        AbstractTermsBucket lastBucket = null;
        while (pq.size() > 0) {
            IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
            assert (lastBucket == null || cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0);
            if (lastBucket != null && cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) != 0) {
                InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reducedBuckets.add(reduced);
                currentBuckets.clear();
            }
            lastBucket = (AbstractTermsBucket)top.current();
            currentBuckets.add((AbstractTermsBucket)top.current());
            if (top.hasNext()) {
                top.next();
                assert (cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0) : "shards must return data sorted by key";
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (!currentBuckets.isEmpty()) {
            InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
            reducedBuckets.add(reduced);
        }
        return reducedBuckets;
    }

    private List<B> reduceLegacy(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<Object, List> bucketMap = new HashMap<Object, List>();
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            for (AbstractTermsBucket bucket : terms.getBuckets()) {
                bucketMap.computeIfAbsent(bucket.getKey(), k -> new ArrayList()).add(bucket);
            }
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> reducedBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (List sameTermBuckets : bucketMap.values()) {
            InternalMultiBucketAggregation.InternalBucket b = this.reduceBucket(sameTermBuckets, reduceContext);
            reducedBuckets.add(b);
        }
        return reducedBuckets;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        AbstractTermsBucket[] list;
        int size;
        List<B> reducedBuckets;
        long sumDocCountError = 0L;
        long otherDocCount = 0L;
        Object referenceTerms = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (referenceTerms == null && terms.isMapped()) {
                referenceTerms = terms;
            }
            if (referenceTerms != null && !referenceTerms.getClass().equals(terms.getClass()) && terms.isMapped()) {
                throw new AggregationExecutionException("Merging/Reducing the aggregations failed when computing the aggregation [" + ((InternalAggregation)referenceTerms).getName() + "] because the field you gave in the aggregation query existed as two different types in two different indices");
            }
            otherDocCount += terms.getSumOfOtherDocCounts();
            long thisAggDocCountError = this.getDocCountError(terms);
            if (sumDocCountError != -1L) {
                sumDocCountError = thisAggDocCountError == -1L ? -1L : (sumDocCountError += thisAggDocCountError);
            }
            this.setDocCountError(thisAggDocCountError);
            for (AbstractTermsBucket bucket : terms.getBuckets()) {
                bucket.updateDocCountError(-thisAggDocCountError);
            }
        }
        BucketOrder thisReduceOrder = this.getReduceOrder(aggregations);
        if (InternalOrder.isKeyOrder(thisReduceOrder)) {
            thisReduceOrder = InternalOrder.key(InternalOrder.isKeyAsc(thisReduceOrder));
            reducedBuckets = this.reduceMergeSort(aggregations, thisReduceOrder, reduceContext);
        } else {
            reducedBuckets = this.reduceLegacy(aggregations, reduceContext);
        }
        if (reduceContext.isFinalReduce()) {
            size = Math.min(this.getRequiredSize(), reducedBuckets.size());
            BucketPriorityQueue<MultiBucketsAggregation.Bucket> ordered = new BucketPriorityQueue<MultiBucketsAggregation.Bucket>(size, this.getOrder().comparator());
            for (AbstractTermsBucket bucket : reducedBuckets) {
                if (sumDocCountError == -1L) {
                    bucket.setDocCountError(-1L);
                } else {
                    bucket.updateDocCountError(sumDocCountError);
                }
                if (bucket.getDocCount() >= this.getMinDocCount()) {
                    AbstractTermsBucket removed = ordered.insertWithOverflow(bucket);
                    if (removed != null) {
                        otherDocCount += removed.getDocCount();
                        reduceContext.consumeBucketsAndMaybeBreak(-AbstractInternalTerms.countInnerBucket(removed));
                        continue;
                    }
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    continue;
                }
                reduceContext.consumeBucketsAndMaybeBreak(-AbstractInternalTerms.countInnerBucket(bucket));
            }
            list = this.createBucketsArray(ordered.size());
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (AbstractTermsBucket)ordered.pop();
            }
        } else {
            size = InternalOrder.isKeyOrder(this.getOrder()) && this.getMinDocCount() == 0L ? Math.min(this.getRequiredSize(), reducedBuckets.size()) : reducedBuckets.size();
            list = this.createBucketsArray(size);
            for (int i = 0; i < size; ++i) {
                reduceContext.consumeBucketsAndMaybeBreak(1);
                list[i] = (AbstractTermsBucket)reducedBuckets.get(i);
                if (sumDocCountError == -1L) {
                    list[i].setDocCountError(-1L);
                    continue;
                }
                list[i].updateDocCountError(sumDocCountError);
            }
        }
        long docCountError = sumDocCountError == -1L ? -1L : (aggregations.size() == 1 ? 0L : sumDocCountError);
        return this.create(this.name, Arrays.asList(list), reduceContext.isFinalReduce() ? this.getOrder() : thisReduceOrder, docCountError, otherDocCount);
    }

    protected static XContentBuilder doXContentCommon(XContentBuilder builder, ToXContent.Params params, long docCountError, long otherDocCount, List<? extends AbstractTermsBucket> buckets) throws IOException {
        builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), docCountError);
        builder.field(InternalTerms.SUM_OF_OTHER_DOC_COUNTS.getPreferredName(), otherDocCount);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (AbstractTermsBucket abstractTermsBucket : buckets) {
            abstractTermsBucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static abstract class AbstractTermsBucket
    extends InternalMultiBucketAggregation.InternalBucket {
        protected abstract void updateDocCountError(long var1);

        protected abstract void setDocCountError(long var1);

        protected abstract boolean getShowDocCountError();

        protected abstract long getDocCountError();
    }
}

