/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.RefCounted;
import org.elasticsearch.transport.TransportRequest;

public class BytesTransportRequest
extends TransportRequest
implements RefCounted {
    final ReleasableBytesReference bytes;
    private final Version version;

    public BytesTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.bytes = in.readReleasableBytesReference();
        this.version = in.getVersion();
    }

    public BytesTransportRequest(BytesReference bytes, Version version) {
        this.bytes = ReleasableBytesReference.wrap(bytes);
        this.version = version;
    }

    public Version version() {
        return this.version;
    }

    public BytesReference bytes() {
        return this.bytes;
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.bytes.length());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.bytes);
    }

    @Override
    public void incRef() {
        this.bytes.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.bytes.decRef();
    }

    @Override
    public boolean decRef() {
        return this.bytes.decRef();
    }
}

