/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class Jenkins
implements CiVendor {
    private static final Logger LOG = Loggers.get(Jenkins.class);
    private final System2 system;
    private final DefaultInputProject inputProject;

    public Jenkins(System2 system, DefaultInputProject inputProject) {
        this.system = system;
        this.inputProject = inputProject;
    }

    @Override
    public String getName() {
        return "Jenkins";
    }

    @Override
    public boolean isDetected() {
        return StringUtils.isNotBlank(this.system.envVariable("JENKINS_URL")) && StringUtils.isNotBlank(this.system.envVariable("EXECUTOR_NUMBER"));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable("ghprbActualCommit");
        if (StringUtils.isNotBlank(revision)) {
            return new CiConfigurationImpl(revision, this.getName());
        }
        revision = this.system.envVariable("GIT_COMMIT");
        if (StringUtils.isNotBlank(revision)) {
            String jenkinsGitPrSha1;
            if (StringUtils.isNotBlank(this.system.envVariable("CHANGE_ID")) && StringUtils.isNotBlank(jenkinsGitPrSha1 = this.getJenkinsGitPrSha1())) {
                return new CiConfigurationImpl(jenkinsGitPrSha1, this.getName());
            }
            return new CiConfigurationImpl(revision, this.getName());
        }
        revision = this.system.envVariable("SVN_COMMIT");
        return new CiConfigurationImpl(revision, this.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJenkinsGitPrSha1() {
        String gitBranch = this.system.envVariable("GIT_BRANCH");
        if (StringUtils.isBlank(gitBranch)) {
            return null;
        }
        Path baseDir = this.inputProject.getBaseDir();
        RepositoryBuilder builder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().findGitDir(baseDir.toFile())).setMustExist(true);
        if (builder.getGitDir() == null) {
            return null;
        }
        String refName = "refs/remotes/origin/" + gitBranch;
        try (Object repo = builder.build();){
            Ref ref = ((Repository)repo).exactRef(refName);
            if (ref == null) return null;
            String string = ref.getObjectId().getName();
            return string;
        }
        catch (Exception e) {
            LOG.debug("Couldn't find git sha1 in '{}': {}", (Object)refName, (Object)e.getMessage());
        }
        return null;
    }
}

