/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ReportParser {
    private Gson gson = new Gson();
    private Path filePath;

    public ReportParser(Path filePath) {
        this.filePath = filePath;
    }

    public Report parse() {
        Report report;
        block9: {
            BufferedReader reader = Files.newBufferedReader(this.filePath, StandardCharsets.UTF_8);
            try {
                report = this.validate(this.gson.fromJson((Reader)reader, Report.class));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonIOException | IOException e) {
                    throw new IllegalStateException("Failed to read external issues report '" + this.filePath + "'", e);
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalStateException("Failed to read external issues report '" + this.filePath + "': invalid JSON syntax", e);
                }
            }
            ((Reader)reader).close();
        }
        return report;
    }

    private Report validate(Report report) {
        for (Issue issue : report.issues) {
            this.mandatoryField(issue.primaryLocation, "primaryLocation");
            this.mandatoryField(issue.engineId, "engineId");
            this.mandatoryField(issue.ruleId, "ruleId");
            this.mandatoryField(issue.severity, "severity");
            this.mandatoryField(issue.type, "type");
            this.mandatoryField(issue.primaryLocation, "primaryLocation");
            this.mandatoryFieldPrimaryLocation(issue.primaryLocation.filePath, "filePath");
            this.mandatoryFieldPrimaryLocation(issue.primaryLocation.message, "message");
            if (issue.primaryLocation.textRange != null) {
                this.mandatoryFieldPrimaryLocation(issue.primaryLocation.textRange.startLine, "startLine of the text range");
            }
            if (issue.secondaryLocations == null) continue;
            for (Location l : issue.secondaryLocations) {
                this.mandatoryFieldSecondaryLocation(l.filePath, "filePath");
                this.mandatoryFieldSecondaryLocation(l.textRange, "textRange");
                this.mandatoryFieldSecondaryLocation(l.textRange.startLine, "startLine of the text range");
            }
        }
        return report;
    }

    private void mandatoryFieldPrimaryLocation(@Nullable Object value, String fieldName) {
        if (value == null) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s' in the primary location of the issue.", this.filePath, fieldName));
        }
    }

    private void mandatoryFieldSecondaryLocation(@Nullable Object value, String fieldName) {
        if (value == null) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s' in a secondary location of the issue.", this.filePath, fieldName));
        }
    }

    private void mandatoryField(@Nullable Object value, String fieldName) {
        if (value == null) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s'.", this.filePath, fieldName));
        }
    }

    private void mandatoryField(@Nullable String value, String fieldName) {
        if (StringUtils.isBlank(value)) {
            throw new IllegalStateException(String.format("Failed to parse report '%s': missing mandatory field '%s'.", this.filePath, fieldName));
        }
    }

    static class TextRange {
        Integer startLine;
        @Nullable
        Integer startColumn;
        @Nullable
        Integer endLine;
        @Nullable
        Integer endColumn;
    }

    static class Location {
        @Nullable
        String message;
        String filePath;
        @Nullable
        TextRange textRange;
    }

    static class Issue {
        String engineId;
        String ruleId;
        String severity;
        String type;
        @Nullable
        Integer effortMinutes;
        Location primaryLocation;
        @Nullable
        Location[] secondaryLocations;
    }

    static class Report {
        Issue[] issues;
    }
}

