/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Collections;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Rule(key="S5332")
public class AndroidClearTextCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Make sure allowing clear-text traffic is safe here.";
    private static final String MESSAGE_IMPLICIT = "\"usesCleartextTraffic\" is implicitly enabled for older Android versions. Make sure allowing clear-text traffic is safe here.";
    private static final String ANDROID_NAME_SPACE = "http://schemas.android.com/apk/res/android";
    private final XPathExpression xPathClearTextTrue = XPathBuilder.forExpression("/manifest/application[@n:usesCleartextTraffic='true']").withNamespace("n", "http://schemas.android.com/apk/res/android").build();
    private final XPathExpression xPathClearTextImplicit = XPathBuilder.forExpression("/manifest/application[not(@n:usesCleartextTraffic)]").withNamespace("n", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected void scanAndroidManifest(XmlFile file) {
        Document document = file.getDocument();
        this.evaluateAsList(this.xPathClearTextTrue, document).forEach(node -> this.reportAtNameLocation((Node)node, MESSAGE));
        this.evaluateAsList(this.xPathClearTextImplicit, document).forEach(node -> this.reportAtNameLocation((Node)node, MESSAGE_IMPLICIT));
    }

    private void reportAtNameLocation(Node node, String message) {
        this.reportIssue(XmlFile.nameLocation((Element)node), message, Collections.emptyList());
    }
}

