/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.AbstractWebXmlCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Rule(key="S2647")
public class BasicAuthenticationCheck
extends AbstractWebXmlCheck {
    private XPathExpression authMethodBasicExpression = XPathBuilder.forExpression("/j:web-app/j:login-config/j:auth-method[.='BASIC']").withNamespace("j", "http://xmlns.jcp.org/xml/ns/javaee").build();
    private XPathExpression httpsEnabledExpression = XPathBuilder.forExpression("/j:web-app/j:security-constraint/j:user-data-constraint/j:transport-guarantee[.='CONFIDENTIAL']").withNamespace("j", "http://xmlns.jcp.org/xml/ns/javaee").build();

    @Override
    void scanWebXml(XmlFile file) {
        Document webApp = file.getDocument();
        if (!this.evaluateAsList(this.httpsEnabledExpression, webApp).isEmpty()) {
            return;
        }
        this.evaluateAsList(this.authMethodBasicExpression, webApp).forEach(node -> this.reportIssue((Node)node, "Use a more secure method than basic authentication."));
    }
}

