/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.mac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.NamedFactoriesListParseResult;
import org.apache.sshd.common.mac.BaseMac;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public enum BuiltinMacs implements MacFactory
{
    hmacmd5("hmac-md5", "HmacMD5", 16, 16),
    hmacmd596("hmac-md5-96", "HmacMD5", 12, 16),
    hmacsha1("hmac-sha1", "HmacSHA1", 20, 20),
    hmacsha1etm("hmac-sha1-etm@openssh.com", "HmacSHA1", 20, 20){

        @Override
        public boolean isEncryptThenMac() {
            return true;
        }
    }
    ,
    hmacsha196("hmac-sha1-96", "HmacSHA1", 12, 20),
    hmacsha256("hmac-sha2-256", "HmacSHA256", 32, 32),
    hmacsha256etm("hmac-sha2-256-etm@openssh.com", "HmacSHA256", 32, 32){

        @Override
        public boolean isEncryptThenMac() {
            return true;
        }
    }
    ,
    hmacsha512("hmac-sha2-512", "HmacSHA512", 64, 64),
    hmacsha512etm("hmac-sha2-512-etm@openssh.com", "HmacSHA512", 64, 64){

        @Override
        public boolean isEncryptThenMac() {
            return true;
        }
    };

    public static final Set<BuiltinMacs> VALUES;
    private static final Map<String, MacFactory> EXTENSIONS;
    private final String factoryName;
    private final String algorithm;
    private final int defbsize;
    private final int bsize;

    private BuiltinMacs(String factoryName, String algorithm, int bsize, int defbsize) {
        this.factoryName = factoryName;
        this.algorithm = algorithm;
        this.bsize = bsize;
        this.defbsize = defbsize;
    }

    @Override
    public Mac create() {
        return new BaseMac(this.getAlgorithm(), this.getBlockSize(), this.getDefaultBlockSize(), this.isEncryptThenMac());
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final int getBlockSize() {
        return this.bsize;
    }

    @Override
    public final int getDefaultBlockSize() {
        return this.defbsize;
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(MacFactory extension) {
        String name = Objects.requireNonNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinMacs.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, MacFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<MacFactory> getRegisteredExtensions() {
        Map<String, MacFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MacFactory unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, MacFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinMacs fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (BuiltinMacs c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static BuiltinMacs fromFactory(NamedFactory<Mac> factory2) {
        if (factory2 == null) {
            return null;
        }
        return BuiltinMacs.fromFactoryName(factory2.getName());
    }

    public static BuiltinMacs fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ParseResult parseMacsList(String macs) {
        return BuiltinMacs.parseMacsList(GenericUtils.split(macs, ','));
    }

    public static ParseResult parseMacsList(String ... macs) {
        return BuiltinMacs.parseMacsList(GenericUtils.isEmpty((Object[])macs) ? Collections.emptyList() : Arrays.asList(macs));
    }

    public static ParseResult parseMacsList(Collection<String> macs) {
        if (GenericUtils.isEmpty(macs)) {
            return ParseResult.EMPTY;
        }
        ArrayList<MacFactory> factories = new ArrayList<MacFactory>(macs.size());
        List<String> unknown = Collections.emptyList();
        for (String name : macs) {
            MacFactory m = BuiltinMacs.resolveFactory(name);
            if (m != null) {
                factories.add(m);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<MacFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MacFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinMacs m = BuiltinMacs.fromFactoryName(name);
        if (m != null) {
            return m;
        }
        Map<String, MacFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinMacs.class));
        EXTENSIONS = new TreeMap<String, MacFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static final class Constants {
        public static final String HMAC_MD5 = "hmac-md5";
        public static final String HMAC_MD5_96 = "hmac-md5-96";
        public static final String HMAC_SHA1 = "hmac-sha1";
        public static final String HMAC_SHA1_96 = "hmac-sha1-96";
        public static final String HMAC_SHA2_256 = "hmac-sha2-256";
        public static final String HMAC_SHA2_512 = "hmac-sha2-512";
        public static final String ETM_HMAC_SHA1 = "hmac-sha1-etm@openssh.com";
        public static final String ETM_HMAC_SHA2_256 = "hmac-sha2-256-etm@openssh.com";
        public static final String ETM_HMAC_SHA2_512 = "hmac-sha2-512-etm@openssh.com";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }

    public static final class ParseResult
    extends NamedFactoriesListParseResult<Mac, MacFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<MacFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

