/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.TtyFilterInputStream;
import org.apache.sshd.server.shell.TtyFilterOutputStream;

public class ProcessShell
extends AbstractLoggingBean
implements InvertedShell {
    private final List<String> command;
    private String cmdValue;
    private ServerSession session;
    private ChannelSession channelSession;
    private Process process;
    private TtyFilterOutputStream in;
    private TtyFilterInputStream out;
    private TtyFilterInputStream err;

    public ProcessShell(String ... command) {
        this(GenericUtils.isEmpty(command) ? Collections.emptyList() : Arrays.asList(command));
    }

    public ProcessShell(Collection<String> command) {
        this.command = new ArrayList<String>(ValidateUtils.checkNotNullAndNotEmpty(command, "No process shell command(s)", new Object[0]));
        this.cmdValue = GenericUtils.join(command, ' ');
    }

    @Override
    public ServerSession getServerSession() {
        return this.session;
    }

    @Override
    public void setSession(ServerSession session) {
        this.session = Objects.requireNonNull(session, "No server session");
        ValidateUtils.checkTrue(this.process == null, "Session set after process started");
    }

    @Override
    public ChannelSession getServerChannelSession() {
        return this.channelSession;
    }

    @Override
    public void start(ChannelSession channel, Environment env) throws IOException {
        this.channelSession = channel;
        Map<String, String> varsMap = this.resolveShellEnvironment(env.getEnv());
        for (int i = 0; i < this.command.size(); ++i) {
            String cmd = this.command.get(i);
            if (!"$USER".equals(cmd)) continue;
            cmd = varsMap.get("USER");
            this.command.set(i, cmd);
            this.cmdValue = GenericUtils.join(this.command, ' ');
        }
        ProcessBuilder builder = new ProcessBuilder(this.command);
        if (MapEntryUtils.size(varsMap) > 0) {
            try {
                Map<String, String> procEnv = builder.environment();
                procEnv.putAll(varsMap);
            }
            catch (Exception e) {
                this.warn("start({}) - Failed ({}) to set environment for command={}: {}", channel, e.getClass().getSimpleName(), this.cmdValue, e.getMessage(), e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("start({}): command='{}', env={}", channel, builder.command(), builder.environment());
        }
        this.process = builder.start();
        Map<PtyMode, Integer> modes = this.resolveShellTtyOptions(env.getPtyModes());
        this.out = new TtyFilterInputStream(this.process.getInputStream(), modes);
        this.err = new TtyFilterInputStream(this.process.getErrorStream(), modes);
        this.in = new TtyFilterOutputStream(this.process.getOutputStream(), this.err, modes);
    }

    protected Map<String, String> resolveShellEnvironment(Map<String, String> env) {
        return env;
    }

    protected Map<PtyMode, Integer> resolveShellTtyOptions(Map<PtyMode, Integer> modes) {
        if (PuttyRequestHandler.isPuttyClient(this.getServerSession())) {
            return PuttyRequestHandler.resolveShellTtyOptions(modes);
        }
        return modes;
    }

    @Override
    public OutputStream getInputStream() {
        return this.in;
    }

    @Override
    public InputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int exitValue() {
        if (this.isAlive()) {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.process.exitValue();
    }

    @Override
    public void destroy(ChannelSession channel) {
        IOException e;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.process != null) {
            if (debugEnabled) {
                this.log.debug("destroy({}) Destroy process for '{}'", (Object)channel, (Object)this.cmdValue);
            }
            this.process.destroy();
        }
        if ((e = IoUtils.closeQuietly(this.getInputStream(), this.getOutputStream(), this.getErrorStream())) != null) {
            this.debug("destroy({}) {} while destroy streams of '{}': {}", channel, e.getClass().getSimpleName(), this, e.getMessage(), e);
        }
    }

    public String toString() {
        return GenericUtils.isEmpty(this.cmdValue) ? super.toString() : this.cmdValue;
    }
}

