/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.merge.WorkTreeUpdater;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.submodule.SubmoduleConflict;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.TemporaryBuffer;

public class ResolveMerger
extends ThreeWayMerger {
    protected NameConflictTreeWalk tw;
    protected String[] commitNames;
    protected static final int T_BASE = 0;
    protected static final int T_OURS = 1;
    protected static final int T_THEIRS = 2;
    protected static final int T_INDEX = 3;
    protected static final int T_FILE = 4;
    protected WorkTreeUpdater workTreeUpdater;
    protected ObjectId resultTree;
    protected List<String> modifiedFiles = new ArrayList<String>();
    protected List<String> unmergedPaths = new ArrayList<String>();
    protected Map<String, MergeResult<? extends Sequence>> mergeResults = new HashMap<String, MergeResult<? extends Sequence>>();
    protected Map<String, MergeFailureReason> failingPaths = new HashMap<String, MergeFailureReason>();
    protected boolean enterSubtree;
    protected boolean inCore;
    protected DirCache dircache;
    protected WorkingTreeIterator workingTreeIterator;
    protected MergeAlgorithm mergeAlgorithm;
    @NonNull
    private ContentMergeStrategy contentStrategy = ContentMergeStrategy.CONFLICT;
    private static final Attributes NO_ATTRIBUTES = new Attributes(new Attribute[0]);

    private static MergeAlgorithm getMergeAlgorithm(Config config) {
        DiffAlgorithm.SupportedAlgorithm diffAlg = config.getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        return new MergeAlgorithm(DiffAlgorithm.getAlgorithm(diffAlg));
    }

    private static String[] defaultCommitNames() {
        return new String[]{"BASE", "OURS", "THEIRS"};
    }

    protected ResolveMerger(Repository local, boolean inCore) {
        super(local);
        StoredConfig config = local.getConfig();
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = inCore;
    }

    protected ResolveMerger(Repository local) {
        this(local, false);
    }

    protected ResolveMerger(ObjectInserter inserter, Config config) {
        super(inserter);
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = true;
    }

    @NonNull
    public ContentMergeStrategy getContentMergeStrategy() {
        return this.contentStrategy;
    }

    public void setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.contentStrategy = strategy == null ? ContentMergeStrategy.CONFLICT : strategy;
    }

    @Override
    protected boolean mergeImpl() throws IOException {
        return this.mergeTrees(this.mergeBase(), this.sourceTrees[0], this.sourceTrees[1], false);
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, Instant lastMod, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            return this.workTreeUpdater.addExistingToIndex(p.getEntryObjectId(), path, p.getEntryFileMode(), stage, lastMod, (int)len);
        }
        return null;
    }

    private DirCacheEntry addConflict(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
        this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
        return this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        return this.workTreeUpdater.addExistingToIndex(e.getObjectId(), e.getRawPath(), e.getFileMode(), e.getStage(), e.getLastModifiedInstant(), e.getLength());
    }

    protected void addToCheckout(String path, DirCacheEntry entry, Attributes[] attributes) throws IOException {
        CoreConfig.EolStreamType cleanupStreamType = this.workTreeUpdater.detectCheckoutStreamType(attributes[1]);
        String cleanupSmudgeCommand = this.tw.getSmudgeCommand(attributes[1]);
        CoreConfig.EolStreamType checkoutStreamType = this.workTreeUpdater.detectCheckoutStreamType(attributes[2]);
        String checkoutSmudgeCommand = this.tw.getSmudgeCommand(attributes[2]);
        this.workTreeUpdater.addToCheckout(path, entry, cleanupStreamType, cleanupSmudgeCommand, checkoutStreamType, checkoutSmudgeCommand);
    }

    protected void addDeletion(String path, boolean isFile, Attributes attributes) throws IOException {
        if (this.db == null || this.nonNullRepo().isBare() || !isFile) {
            return;
        }
        File file = new File(this.nonNullRepo().getWorkTree(), path);
        CoreConfig.EolStreamType streamType = this.workTreeUpdater.detectCheckoutStreamType(attributes);
        String smudgeCommand = this.tw.getSmudgeCommand(attributes);
        this.workTreeUpdater.deleteFile(path, file, streamType, smudgeCommand);
    }

    protected boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work, boolean ignoreConflicts, Attributes[] attributes) throws IOException {
        boolean gitLinkMerging;
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        boolean bl = gitLinkMerging = ResolveMerger.isGitLink(modeO) || ResolveMerger.isGitLink(modeT) || ResolveMerger.isGitLink(modeB);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (ResolveMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId(this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work, ourDce)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (!ignoreConflicts) {
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(this.tw.getPathString());
                this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            }
            return true;
        }
        if (modeB == modeT && this.tw.idEqual(0, 2)) {
            if (ourDce != null) {
                this.keep(ourDce);
            }
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (ResolveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                if (e != null) {
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            if (modeT != 0 && modeT == modeB) {
                return true;
            }
            this.addDeletion(this.tw.getPathString(), ResolveMerger.nonTree(modeO), attributes[1]);
            return true;
        }
        if (this.tw.isSubtree()) {
            if (ResolveMerger.nonTree(modeO) != ResolveMerger.nonTree(modeT)) {
                if (ignoreConflicts) {
                    this.enterSubtree = false;
                    return true;
                }
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                }
                if (ResolveMerger.nonTree(modeO)) {
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                }
                if (ResolveMerger.nonTree(modeT)) {
                    this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                }
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!ResolveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT)) {
            boolean hasSymlink;
            boolean worktreeDirty = this.isWorktreeDirty(work, ourDce);
            if (!attributes[1].canBeContentMerged() && worktreeDirty) {
                return false;
            }
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
                return true;
            }
            if (gitLinkMerging) {
                this.addConflict(base, ours, theirs);
                MergeResult<SubmoduleConflict> result = ResolveMerger.createGitLinksMergeResult(base, ours, theirs);
                result.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (!attributes[1].canBeContentMerged()) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry theirEntry = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), theirEntry, attributes);
                        return true;
                    }
                }
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (worktreeDirty) {
                return false;
            }
            MergeResult<RawText> result = null;
            boolean bl2 = hasSymlink = FileMode.SYMLINK.equals(modeO) || FileMode.SYMLINK.equals(modeT);
            if (!hasSymlink) {
                try {
                    result = this.contentMerge(base, ours, theirs, attributes, this.getContentMergeStrategy());
                }
                catch (BinaryBlobException binaryBlobException) {
                    // empty catch block
                }
            }
            if (result == null) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        if (e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                        return true;
                    }
                }
                result = new MergeResult(Collections.emptyList());
                result.setContainsConflicts(true);
            }
            if (ignoreConflicts) {
                result.setContainsConflicts(false);
            }
            String currentPath = this.tw.getPathString();
            if (hasSymlink) {
                if (ignoreConflicts) {
                    if ((modeT & 0xF000) == 32768) {
                        DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(currentPath, e, attributes);
                    } else {
                        this.keep(ourDce);
                    }
                } else {
                    DirCacheEntry e = this.addConflict(base, ours, theirs);
                    this.mergeResults.put(currentPath, result);
                    if ((modeT & 0xF000) == 32768 && e != null) {
                        this.addToCheckout(currentPath, e, attributes);
                    }
                }
            } else {
                this.updateIndex(base, ours, theirs, result, attributes[1]);
            }
            if (result.containsConflicts() && !ignoreConflicts) {
                this.unmergedPaths.add(currentPath);
            }
            this.workTreeUpdater.markAsModified(currentPath);
            this.addToCheckout(currentPath, null, attributes);
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
            } else if (gitLinkMerging) {
                this.addConflict(base, ours, theirs);
                MergeResult<SubmoduleConflict> result = ResolveMerger.createGitLinksMergeResult(base, ours, theirs);
                result.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
            } else {
                MergeResult<Object> result;
                boolean isSymLink;
                boolean bl3 = isSymLink = ((modeO | modeT) & 0xF000) == 40960;
                if (isSymLink) {
                    result = new MergeResult(Collections.emptyList());
                    result.setContainsConflicts(true);
                } else {
                    try {
                        result = this.contentMerge(base, ours, theirs, attributes, ContentMergeStrategy.CONFLICT);
                    }
                    catch (BinaryBlobException e) {
                        result = new MergeResult(Collections.emptyList());
                        result.setContainsConflicts(true);
                    }
                }
                if (ignoreConflicts) {
                    result.setContainsConflicts(false);
                    if (isSymLink) {
                        if (modeO != 0) {
                            this.keep(ourDce);
                        } else {
                            if (this.isWorktreeDirty(work, ourDce)) {
                                return false;
                            }
                            DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                            if (e != null) {
                                this.addToCheckout(this.tw.getPathString(), e, attributes);
                            }
                        }
                    } else {
                        this.updateIndex(base, ours, theirs, result, attributes[1]);
                    }
                } else {
                    DirCacheEntry e = this.addConflict(base, ours, theirs);
                    if (modeO == 0) {
                        if (this.isWorktreeDirty(work, ourDce)) {
                            return false;
                        }
                        if (ResolveMerger.nonTree(modeT) && e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                    }
                    this.unmergedPaths.add(this.tw.getPathString());
                    this.mergeResults.put(this.tw.getPathString(), result);
                }
            }
        }
        return true;
    }

    private static MergeResult<SubmoduleConflict> createGitLinksMergeResult(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        return new MergeResult<SubmoduleConflict>(Arrays.asList(new SubmoduleConflict(base == null ? null : base.getEntryObjectId()), new SubmoduleConflict(ours == null ? null : ours.getEntryObjectId()), new SubmoduleConflict(theirs == null ? null : theirs.getEntryObjectId())));
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, Attributes[] attributes, ContentMergeStrategy strategy) throws BinaryBlobException, IOException {
        RawText baseText = base == null ? RawText.EMPTY_TEXT : this.getRawText(base.getEntryObjectId(), attributes[0]);
        RawText ourText = ours == null ? RawText.EMPTY_TEXT : this.getRawText(ours.getEntryObjectId(), attributes[1]);
        RawText theirsText = theirs == null ? RawText.EMPTY_TEXT : this.getRawText(theirs.getEntryObjectId(), attributes[2]);
        this.mergeAlgorithm.setContentMergeStrategy(strategy);
        return this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, baseText, ourText, theirsText);
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = ResolveMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work, DirCacheEntry ourDce) throws IOException {
        boolean isDirty;
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        if (ourDce != null) {
            isDirty = work.isModified(ourDce, true, this.reader);
        } else {
            isDirty = work.isModeDifferent(modeO);
            if (!isDirty && ResolveMerger.nonTree(modeF)) {
                boolean bl = isDirty = !this.tw.idEqual(4, 1);
            }
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result, Attributes attributes) throws IOException {
        TemporaryBuffer rawMerged = null;
        try {
            File mergedFile;
            rawMerged = this.doMerge(result);
            File file = mergedFile = this.inCore ? null : this.writeMergedFile(rawMerged, attributes);
            if (result.containsConflicts()) {
                this.addConflict(base, ours, theirs);
                this.mergeResults.put(this.tw.getPathString(), result);
                return;
            }
            Instant lastModified = mergedFile == null ? null : this.nonNullRepo().getFS().lastModifiedInstant(mergedFile);
            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            FileMode mode = newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits(newMode);
            this.workTreeUpdater.insertToIndex(rawMerged.openInputStream(), this.tw.getPathString().getBytes(StandardCharsets.UTF_8), mode, 0, lastModified, (int)rawMerged.length(), attributes.get("merge"));
        }
        finally {
            if (rawMerged != null) {
                rawMerged.destroy();
            }
        }
    }

    private File writeMergedFile(TemporaryBuffer rawMerged, Attributes attributes) throws IOException {
        File workTree = this.nonNullRepo().getWorkTree();
        FS fs = this.nonNullRepo().getFS();
        File of = new File(workTree, this.tw.getPathString());
        File parentFolder = of.getParentFile();
        CoreConfig.EolStreamType eol = this.workTreeUpdater.detectCheckoutStreamType(attributes);
        if (!fs.exists(parentFolder)) {
            parentFolder.mkdirs();
        }
        this.workTreeUpdater.updateFileWithContent(rawMerged::openInputStream, eol, this.tw.getSmudgeCommand(attributes), of.getPath(), of);
        return of;
    }

    private TemporaryBuffer doMerge(MergeResult<RawText> result) throws IOException {
        TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.workTreeUpdater.getInCoreFileSizeLimit());
        boolean success = false;
        try {
            new MergeFormatter().formatMerge((OutputStream)buf, result, Arrays.asList(this.commitNames), StandardCharsets.UTF_8);
            buf.close();
            success = true;
        }
        finally {
            if (!success) {
                buf.destroy();
            }
        }
        return buf;
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private RawText getRawText(ObjectId id, Attributes attributes) throws IOException, BinaryBlobException {
        if (id.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader loader = LfsFactory.getInstance().applySmudgeFilter(this.getRepository(), this.reader.open(id, 3), attributes.get("merge"));
        int threshold = 0x3200000;
        return RawText.load(loader, threshold);
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] commitNames) {
        this.commitNames = commitNames;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List<String> getModifiedFiles() {
        return this.workTreeUpdater != null ? this.workTreeUpdater.getModifiedFiles() : this.modifiedFiles;
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.workTreeUpdater.getToBeCheckedOut();
    }

    public Map<String, MergeResult<? extends Sequence>> getMergeResults() {
        return this.mergeResults;
    }

    public Map<String, MergeFailureReason> getFailingPaths() {
        return this.failingPaths.isEmpty() ? null : this.failingPaths;
    }

    public boolean failed() {
        return !this.failingPaths.isEmpty();
    }

    public void setDirCache(DirCache dc) {
        this.dircache = dc;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree, boolean ignoreConflicts) throws IOException {
        try {
            this.workTreeUpdater = this.inCore ? WorkTreeUpdater.createInCoreWorkTreeUpdater(this.db, this.dircache, this.getObjectInserter()) : WorkTreeUpdater.createWorkTreeUpdater(this.db, this.dircache);
            this.dircache = this.workTreeUpdater.getLockedDirCache();
            this.tw = new NameConflictTreeWalk(this.db, this.reader);
            this.tw.addTree(baseTree);
            this.tw.setHead(this.tw.addTree(headTree));
            this.tw.addTree(mergeTree);
            DirCacheBuildIterator buildIt = this.workTreeUpdater.createDirCacheBuildIterator();
            int dciPos = this.tw.addTree(buildIt);
            if (this.workingTreeIterator != null) {
                this.tw.addTree(this.workingTreeIterator);
                this.workingTreeIterator.setDirCacheIterator(this.tw, dciPos);
            } else {
                this.tw.setFilter(TreeFilter.ANY_DIFF);
            }
            if (!this.mergeTreeWalk(this.tw, ignoreConflicts)) {
                return false;
            }
            this.workTreeUpdater.writeWorkTreeChanges(true);
            if (this.getUnmergedPaths().isEmpty() && !this.failed()) {
                WorkTreeUpdater.Result result = this.workTreeUpdater.writeIndexChanges();
                this.resultTree = result.getTreeId();
                this.modifiedFiles = result.getModifiedFiles();
                for (String f : result.getFailedToDelete()) {
                    this.failingPaths.put(f, MergeFailureReason.COULD_NOT_DELETE);
                }
                boolean bl = result.getFailedToDelete().isEmpty();
                return bl;
            }
            this.resultTree = null;
            return false;
        }
        finally {
            if (this.modifiedFiles.isEmpty()) {
                this.modifiedFiles = this.workTreeUpdater.getModifiedFiles();
            }
            this.workTreeUpdater.close();
            this.workTreeUpdater = null;
        }
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        boolean hasWorkingTreeIterator = this.tw.getTreeCount() > 4;
        boolean hasAttributeNodeProvider = treeWalk.getAttributesNodeProvider() != null;
        while (treeWalk.next()) {
            Attributes[] attributes = new Attributes[]{NO_ATTRIBUTES, NO_ATTRIBUTES, NO_ATTRIBUTES};
            if (hasAttributeNodeProvider) {
                attributes[0] = treeWalk.getAttributes(0);
                attributes[1] = treeWalk.getAttributes(1);
                attributes[2] = treeWalk.getAttributes(2);
            }
            if (!this.processEntry(treeWalk.getTree(0, CanonicalTreeParser.class), treeWalk.getTree(1, CanonicalTreeParser.class), treeWalk.getTree(2, CanonicalTreeParser.class), treeWalk.getTree(3, DirCacheBuildIterator.class), hasWorkingTreeIterator ? treeWalk.getTree(4, WorkingTreeIterator.class) : null, ignoreConflicts, attributes)) {
                this.workTreeUpdater.revertModifiedFiles();
                return false;
            }
            if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
            treeWalk.enterSubtree();
        }
        return true;
    }

    public static enum MergeFailureReason {
        DIRTY_INDEX,
        DIRTY_WORKTREE,
        COULD_NOT_DELETE;

    }
}

