/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.google.gson.annotations.SerializedName;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class Region {
    @SerializedName(value="startLine")
    private final Integer startLine;
    @SerializedName(value="endLine")
    private final Integer endLine;
    @SerializedName(value="startColumn")
    private final Integer startColumn;
    @SerializedName(value="endColumn")
    private final Integer endColumn;

    private Region(Integer startLine, @Nullable Integer endLine, @Nullable Integer startColumn, @Nullable Integer endColumn) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    public static RegionBuilder builder() {
        return new RegionBuilder();
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    @CheckForNull
    public Integer getEndLine() {
        return this.endLine;
    }

    @CheckForNull
    public Integer getStartColumn() {
        return this.startColumn;
    }

    @CheckForNull
    public Integer getEndColumn() {
        return this.endColumn;
    }

    public static final class RegionBuilder {
        private Integer startLine;
        private Integer endLine;
        private Integer startColumn;
        private Integer endColumn;

        public RegionBuilder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        public RegionBuilder endLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        public RegionBuilder startColumn(int startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public RegionBuilder endColumn(int endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        public Region build() {
            return new Region(this.startLine, this.endLine, this.startColumn, this.endColumn);
        }
    }
}

