/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.protocol.output;

import java.io.File;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileStructure {
    private final File dir;

    public FileStructure(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Directory of analysis report does not exist: " + dir);
        }
        this.dir = dir;
    }

    public File metadataFile() {
        return new File(this.dir, "metadata.pb");
    }

    public File analysisCache() {
        return new File(this.dir, "analysis-cache.pb");
    }

    public File analysisLog() {
        return new File(this.dir, "analysis.log");
    }

    public File activeRules() {
        return new File(this.dir, "activerules.pb");
    }

    public File adHocRules() {
        return new File(this.dir, "adhocrules.pb");
    }

    public File fileFor(Domain domain, int componentRef) {
        return new File(this.dir, domain.filePrefix + componentRef + domain.fileSuffix);
    }

    public File contextProperties() {
        return new File(this.dir, "context-props.pb");
    }

    public File analysisWarnings() {
        return new File(this.dir, "analysis-warnings.pb");
    }

    public File root() {
        return this.dir;
    }

    public static enum Domain {
        ISSUES("issues-", ".pb"),
        EXTERNAL_ISSUES("external-issues-", ".pb"),
        COMPONENT("component-", ".pb"),
        MEASURES("measures-", ".pb"),
        DUPLICATIONS("duplications-", ".pb"),
        CPD_TEXT_BLOCKS("cpd-text-block-", ".pb"),
        SYNTAX_HIGHLIGHTINGS("syntax-highlightings-", ".pb"),
        CHANGESETS("changesets-", ".pb"),
        SYMBOLS("symbols-", ".pb"),
        COVERAGES("coverages-", ".pb"),
        SOURCE("source-", ".txt"),
        SGNIFICANT_CODE("sgnificant-code-", ".pb"),
        CHANGED_LINES("changed-lines-", ".pb");

        private static final String PB = ".pb";
        private final String filePrefix;
        private final String fileSuffix;

        private Domain(String filePrefix, String fileSuffix) {
            this.filePrefix = filePrefix;
            this.fileSuffix = fileSuffix;
        }
    }
}

