/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import com.google.protobuf.ByteString;
import java.util.Map;
import org.sonar.scanner.cache.AnalysisCacheEnabled;
import org.sonar.scanner.cache.ScannerWriteCache;
import org.sonar.scanner.protocol.internal.ScannerInternal;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class AnalysisCachePublisher
implements ReportPublisherStep {
    private final AnalysisCacheEnabled analysisCacheEnabled;
    private final BranchConfiguration branchConfiguration;
    private final ScannerWriteCache cache;

    public AnalysisCachePublisher(AnalysisCacheEnabled analysisCacheEnabled, BranchConfiguration branchConfiguration, ScannerWriteCache cache) {
        this.analysisCacheEnabled = analysisCacheEnabled;
        this.branchConfiguration = branchConfiguration;
        this.cache = cache;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        if (!this.analysisCacheEnabled.isEnabled() || this.branchConfiguration.isPullRequest() || this.cache.getCache().isEmpty()) {
            return;
        }
        ScannerInternal.AnalysisCacheMsg.Builder analysisCacheMsg = ScannerInternal.AnalysisCacheMsg.newBuilder();
        for (Map.Entry<String, byte[]> entry : this.cache.getCache().entrySet()) {
            analysisCacheMsg.putMap(entry.getKey(), ByteString.copyFrom(entry.getValue()));
        }
        writer.writeAnalysisCache(analysisCacheMsg.build());
    }
}

