/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonar.api.Startable;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.scanner.scan.DirectoryLock;

public class ProjectLock
implements Startable {
    private final DirectoryLock lock;

    public ProjectLock(AbstractProjectOrModule project) {
        Path directory = project.getWorkDir();
        try {
            if (!directory.toFile().exists()) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create work directory", e);
        }
        this.lock = new DirectoryLock(directory.toAbsolutePath());
    }

    public void tryLock() {
        try {
            if (!this.lock.tryLock()) {
                ProjectLock.failAlreadyInProgress(null);
            }
        }
        catch (OverlappingFileLockException e) {
            ProjectLock.failAlreadyInProgress(e);
        }
    }

    private static void failAlreadyInProgress(Exception e) {
        throw new IllegalStateException("Another SonarQube analysis is already in progress for this project", e);
    }

    @Override
    public void stop() {
        this.lock.unlock();
    }

    @Override
    public void start() {
    }
}

