/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.Collections;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonar.scanner.scan.branch.ProjectBranchesLoader;
import org.springframework.context.annotation.Bean;

public class ProjectBranchesProvider {
    private static final Logger LOG = Loggers.get(ProjectBranchesProvider.class);
    private static final String LOG_MSG = "Load project branches";

    @Bean(value={"ProjectBranches"})
    public ProjectBranches provide(@Nullable ProjectBranchesLoader loader, ScannerProperties scannerProperties) {
        if (loader == null) {
            return new ProjectBranches(Collections.emptyList());
        }
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        ProjectBranches branches = loader.load(scannerProperties.getProjectKey());
        profiler.stopInfo();
        return branches;
    }
}

