/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.typed;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public abstract class Optional<T> {
    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Objects.requireNonNull(reference));
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    @CheckForNull
    public abstract T orNull();

    private static class Absent
    extends Optional<Object> {
        private static final Absent INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("value is absent");
        }

        @Override
        public Object or(Object defaultValue) {
            return Objects.requireNonNull(defaultValue, "use orNull() instead of or(null)");
        }

        @Override
        @CheckForNull
        public Object orNull() {
            return null;
        }

        public boolean equals(@Nullable Object object) {
            return object == this;
        }

        public int hashCode() {
            return 1502476572;
        }

        public String toString() {
            return "Optional.absent()";
        }
    }

    private static class Present<T>
    extends Optional<T> {
        private final T reference;

        public Present(T reference) {
            this.reference = reference;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public T or(Object defaultValue) {
            Objects.requireNonNull(defaultValue, "use orNull() instead of or(null)");
            return this.reference;
        }

        @Override
        @CheckForNull
        public T orNull() {
            return this.reference;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof Present) {
                Present other = (Present)object;
                return this.reference.equals(other.reference);
            }
            return false;
        }

        public int hashCode() {
            return 1502476572 + this.reference.hashCode();
        }

        public String toString() {
            return "Optional.of(" + this.reference + ")";
        }
    }
}

