/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import java.util.function.Consumer;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AzureWeakSSLProtocolCheckPart
extends AbstractNewResourceCheck {
    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_postgresql_server", "azurerm_mysql_server"), this.checkSSLProtocol("ssl_minimal_tls_version_enforced"));
        this.register("azurerm_storage_account", this.checkSSLProtocol("min_tls_version"));
    }

    private Consumer<ResourceSymbol> checkSSLProtocol(String protocolAttribute) {
        return resource -> resource.attribute(protocolAttribute).reportIf(ExpressionPredicate.notEqualTo("TLS1_2"), "Change this code to disable support of older TLS versions.", new SecondaryLocation[0]).reportIfAbsent("Set \"%s\" to disable support of older TLS versions.", new SecondaryLocation[0]);
    }
}

