/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.azure.helper.RoleScopeHelper;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.checks.utils.PredicateUtils;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6385")
public class SubscriptionOwnerCapabilitiesCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Narrow the number of actions or the assignable scope of this custom role.";
    private static final String PERMISSION_MESSAGE = "Allows all actions.";
    private static final String SCOPE_MESSAGE = "High scope level.";
    private static final Predicate<String> REFERENCE_SCOPE_PREDICATE = PredicateUtils.exactMatchStringPredicate("data\\.azurerm_subscription\\.[^.]*(primary|current)[^.]*\\.id|data\\.azurerm_management_group\\.[^.]*(parent|root)[^.]*\\.id");
    private static final Predicate<String> PLAIN_SCOPE_PREDICATE = PredicateUtils.exactMatchStringPredicate("^/subscriptions/[^/]+/?$|^/providers/microsoft\\.management/.+");

    @Override
    protected void registerResourceConsumer() {
        this.register("azurerm_role_definition", (ResourceSymbol resource) -> {
            List ownerPermissions = resource.block("permissions").list("actions").getItemIf(ExpressionPredicate.equalTo("*")).map(scope -> SecondaryLocation.of(scope, PERMISSION_MESSAGE)).collect(Collectors.toList());
            List sensitiveScopes = resource.list("assignable_scopes").getItemIf(scope -> RoleScopeHelper.isSensitiveScope(scope, REFERENCE_SCOPE_PREDICATE, PLAIN_SCOPE_PREDICATE)).map(scope -> SecondaryLocation.of(scope, SCOPE_MESSAGE)).collect(Collectors.toList());
            if (!ownerPermissions.isEmpty() && !sensitiveScopes.isEmpty()) {
                ArrayList<SecondaryLocation> secondaries = new ArrayList<SecondaryLocation>(ownerPermissions);
                secondaries.addAll(sensitiveScopes);
                resource.report(MESSAGE, secondaries);
            }
        });
    }
}

