/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.symbols;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;

public abstract class Symbol<T extends Tree> {
    public final CheckContext ctx;
    @Nullable
    public final T tree;
    public final String name;
    @Nullable
    public final Symbol<? extends Tree> parent;

    protected Symbol(CheckContext ctx, @Nullable T tree, String name, @Nullable Symbol<? extends Tree> parent) {
        this.ctx = ctx;
        this.tree = tree;
        this.name = name;
        this.parent = parent;
    }

    public Symbol<T> reportIfAbsent(String message, SecondaryLocation ... secondaries) {
        if (this.tree == null && this.parent != null) {
            this.parent.report(String.format(message, this.name), List.of(secondaries));
        }
        return this;
    }

    public Symbol<T> report(String message, SecondaryLocation ... secondaryLocations) {
        return this.report(message, List.of(secondaryLocations));
    }

    public Symbol<T> report(String message, List<SecondaryLocation> secondaries) {
        HasTextRange toHighlight = this.toHighlight();
        if (toHighlight != null) {
            this.ctx.reportIssue(toHighlight, message, secondaries);
        }
        return this;
    }

    @Nullable
    public SecondaryLocation toSecondary(String message) {
        HasTextRange toHighlight = this.toHighlight();
        if (toHighlight != null) {
            return new SecondaryLocation(toHighlight, message);
        }
        return null;
    }

    @CheckForNull
    protected abstract HasTextRange toHighlight();

    public boolean isPresent() {
        return this.tree != null;
    }

    public boolean isAbsent() {
        return this.tree == null;
    }
}

