/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.MetadataTag;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S1469")
public class ArrayFieldElementTypeCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        for (AstNode directive : Clazz.getDirectives(astNode)) {
            if (!Variable.isVariable(directive)) continue;
            AstNode varBindingList = directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE).getFirstChild(FlexGrammar.VARIABLE_DECLARATION_STATEMENT).getFirstChild(FlexGrammar.VARIABLE_DEF).getFirstChild(FlexGrammar.VARIABLE_BINDING_LIST);
            this.checkVarBindingList(varBindingList, directive);
        }
    }

    private void checkVarBindingList(AstNode varBindingList, AstNode directive) {
        for (AstNode varBinding : varBindingList.getChildren(FlexGrammar.VARIABLE_BINDING)) {
            if (ArrayFieldElementTypeCheck.hasInitialisation(varBinding) || !ArrayFieldElementTypeCheck.isArray(varBinding) || ArrayFieldElementTypeCheck.hasArrayTypeTag(directive)) continue;
            String message = MessageFormat.format("Define the element type for this ''{0}'' array", varBinding.getFirstChild(FlexGrammar.TYPED_IDENTIFIER).getFirstChild(FlexGrammar.IDENTIFIER).getTokenValue());
            this.addIssue(message, varBinding);
        }
    }

    private static boolean hasInitialisation(AstNode varBinding) {
        return varBinding.getFirstChild(FlexGrammar.VARIABLE_INITIALISATION) != null;
    }

    private static boolean isArray(AstNode varBinding) {
        AstNode typeExpr = varBinding.getFirstChild(FlexGrammar.TYPED_IDENTIFIER).getFirstChild(FlexGrammar.TYPE_EXPR);
        return typeExpr != null && typeExpr.getNumberOfChildren() == 1 && "Array".equals(typeExpr.getFirstChild().getTokenValue());
    }

    private static boolean hasArrayTypeTag(AstNode directive) {
        for (AstNode previousDirective = directive.getPreviousAstNode(); previousDirective != null && MetadataTag.isMetadataTag(previousDirective); previousDirective = previousDirective.getPreviousAstNode()) {
            if (!MetadataTag.isTag(previousDirective.getFirstChild().getFirstChild(FlexGrammar.METADATA_STATEMENT), "ArrayElementType")) continue;
            return true;
        }
        return false;
    }
}

