/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.dev;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.sonarsource.kotlin.dev.AstPrinter;
import org.sonarsource.kotlin.dev.AstPrinterKt;
import org.sonarsource.kotlin.dev.DotNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00060\u00070\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u000bJ\u0016\u0010\n\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u000b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/dev/AstPrinter;", "", "()V", "INDENT", "", "collectAllNodesAndEdges", "Lkotlin/Pair;", "", "Lorg/sonarsource/kotlin/dev/DotNode;", "node", "dotPrint", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "outputFile", "Ljava/nio/file/Path;", "dotPrintAllNodes", "toDotString", "toTxtString", "indentLevel", "", "txtPrint", "document", "Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;", "sonar-kotlin-plugin"})
public final class AstPrinter {
    @NotNull
    public static final AstPrinter INSTANCE = new AstPrinter();
    @NotNull
    private static final String INDENT = "  ";

    private AstPrinter() {
    }

    @NotNull
    public final String dotPrint(@NotNull PsiElement node) {
        Intrinsics.checkNotNullParameter(node, "node");
        return this.dotPrint(DotNode.Companion.of(node, null));
    }

    public final void dotPrint(@NotNull PsiElement node, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        this.dotPrint(DotNode.Companion.of(node, null), outputFile);
    }

    @NotNull
    public final String dotPrint(@NotNull DotNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        return this.toDotString(node);
    }

    public final void dotPrint(@NotNull DotNode node, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        PathsKt.writeText$default(outputFile, this.dotPrint(node), null, new OpenOption[0], 2, null);
    }

    @NotNull
    public final String txtPrint(@NotNull PsiElement node, @Nullable Document document) {
        Intrinsics.checkNotNullParameter(node, "node");
        return this.txtPrint(DotNode.Companion.of(node, document));
    }

    public static /* synthetic */ String txtPrint$default(AstPrinter astPrinter, PsiElement psiElement, Document document, int n, Object object) {
        if ((n & 2) != 0) {
            document = null;
        }
        return astPrinter.txtPrint(psiElement, document);
    }

    public final void txtPrint(@NotNull PsiElement node, @NotNull Path outputFile, @Nullable Document document) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        this.txtPrint(DotNode.Companion.of(node, document), outputFile);
    }

    public static /* synthetic */ void txtPrint$default(AstPrinter astPrinter, PsiElement psiElement, Path path2, Document document, int n, Object object) {
        if ((n & 4) != 0) {
            document = null;
        }
        astPrinter.txtPrint(psiElement, path2, document);
    }

    @NotNull
    public final String txtPrint(@NotNull DotNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        return AstPrinter.toTxtString$default(this, node, 0, 2, null);
    }

    public final void txtPrint(@NotNull DotNode node, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        PathsKt.writeText$default(outputFile, this.txtPrint(node), null, new OpenOption[0], 2, null);
    }

    private final String toTxtString(DotNode node, int indentLevel) {
        return StringsKt.repeat(INDENT, indentLevel) + node.getType() + " " + AstPrinterKt.access$prettyString(node.getRange()) + ": " + node.txtLabel() + "\n" + CollectionsKt.joinToString$default(node.getChildren(), "", null, null, 0, null, new Function1<DotNode, CharSequence>(indentLevel){
            final /* synthetic */ int $indentLevel;
            {
                this.$indentLevel = $indentLevel;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull DotNode it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return AstPrinter.access$toTxtString(AstPrinter.INSTANCE, it, this.$indentLevel + 1);
            }
        }, 30, null);
    }

    static /* synthetic */ String toTxtString$default(AstPrinter astPrinter, DotNode dotNode, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return astPrinter.toTxtString(dotNode, n);
    }

    private final String toDotString(DotNode node) {
        return "digraph {\n  graph [rankdir = LR]\n" + this.dotPrintAllNodes(node) + "\n}";
    }

    private final String dotPrintAllNodes(DotNode node) {
        Pair<List<DotNode>, List<Pair<DotNode, DotNode>>> pair = this.collectAllNodesAndEdges(node);
        List<DotNode> nodes = pair.component1();
        List<Pair<DotNode, DotNode>> edges = pair.component2();
        return CollectionsKt.joinToString$default(nodes, "\n", null, null, 0, null, dotPrintAllNodes.1.INSTANCE, 30, null) + "\n" + CollectionsKt.joinToString$default(edges, "\n", null, null, 0, null, dotPrintAllNodes.2.INSTANCE, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<DotNode>, List<Pair<DotNode, DotNode>>> collectAllNodesAndEdges(DotNode node) {
        void $this$foldRight$iv;
        void $this$mapTo$iv$iv;
        List localEdges = new ArrayList();
        Iterable $this$map$iv = node.getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DotNode dotNode = (DotNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            localEdges.add(TuplesKt.to(node, it));
            collection.add(INSTANCE.collectAllNodesAndEdges((DotNode)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        Pair initial$iv = TuplesKt.to(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        boolean $i$f$foldRight = false;
        Pair accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                Pair pair = accumulator$iv;
                Pair x = (Pair)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = TuplesKt.to(CollectionsKt.plus((Collection)x.getFirst(), (Iterable)acc.getFirst()), CollectionsKt.plus((Collection)x.getSecond(), (Iterable)acc.getSecond()));
            }
        }
        Pair pair = accumulator$iv;
        List nodes = pair.component1();
        List edges = pair.component2();
        return TuplesKt.to(CollectionsKt.plus((Collection)CollectionsKt.listOf(node), (Iterable)nodes), CollectionsKt.plus((Collection)localEdges, (Iterable)edges));
    }

    public static final /* synthetic */ String access$toTxtString(AstPrinter $this, DotNode node, int indentLevel) {
        return $this.toTxtString(node, indentLevel);
    }
}

