/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.caching.Caching;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.python.index.Descriptor;
import org.sonar.python.semantic.DependencyGraph;
import org.sonar.python.semantic.SymbolUtils;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class SonarQubePythonIndexer
extends PythonIndexer {
    public static final String SONAR_CAN_SKIP_UNCHANGED_FILES_KEY = "sonar.python.skipUnchanged";
    private static final Logger LOG = Loggers.get(SonarQubePythonIndexer.class);
    private final Caching caching;
    private final Set<InputFile> skippableFiles = new HashSet<InputFile>();
    private final List<InputFile> mainFiles = new ArrayList<InputFile>();
    private final List<InputFile> testFiles = new ArrayList<InputFile>();
    private final Map<InputFile, String> inputFileToFQN = new HashMap<InputFile, String>();

    public SonarQubePythonIndexer(List<InputFile> inputFiles, CacheContext cacheContext) {
        inputFiles.forEach(f -> {
            if (f.type().equals((Object)InputFile.Type.MAIN)) {
                this.mainFiles.add((InputFile)f);
            } else {
                this.testFiles.add((InputFile)f);
            }
        });
        this.caching = new Caching(cacheContext);
    }

    @Override
    public void buildOnce(SensorContext context) {
        this.projectBaseDirAbsolutePath = context.fileSystem().baseDir().getAbsolutePath();
        this.mainFiles.forEach(f -> this.inputFileToFQN.put((InputFile)f, SymbolUtils.fullyQualifiedModuleName(this.packageName((InputFile)f), f.filename())));
        LOG.debug("Input files for indexing: " + this.mainFiles);
        if (this.shouldOptimizeAnalysis(context)) {
            this.computeGlobalSymbolsUsingCache(context);
            return;
        }
        PerformanceMeasure.Duration duration = PerformanceMeasure.start("ProjectLevelSymbolTable");
        this.computeGlobalSymbols(this.mainFiles, context);
        duration.stop();
    }

    private boolean shouldOptimizeAnalysis(SensorContext context) {
        return this.caching.isCacheEnabled() && (context.canSkipUnchangedFiles() || context.config().getBoolean(SONAR_CAN_SKIP_UNCHANGED_FILES_KEY).orElse(false) != false);
    }

    private void computeGlobalSymbolsUsingCache(SensorContext context) {
        LOG.info("Using cached data to retrieve global symbols.");
        HashSet<String> currentProjectModulesFQNs = new HashSet<String>(this.inputFileToFQN.values());
        Set<String> deletedModulesFQNs = this.deletedModulesFQNs(currentProjectModulesFQNs);
        Set<String> allProjectFilesFQNs = Stream.concat(currentProjectModulesFQNs.stream(), deletedModulesFQNs.stream()).collect(Collectors.toSet());
        HashMap<String, Set<String>> importsByModule = new HashMap<String, Set<String>>();
        ArrayList<InputFile> impactfulFiles = new ArrayList<InputFile>();
        ArrayList<String> impactfulModulesFQNs = new ArrayList<String>(deletedModulesFQNs);
        for (InputFile inputFile : this.mainFiles) {
            String currFQN;
            boolean isUnimpacted = this.tryToUseCache(importsByModule, inputFile, currFQN = this.inputFileToFQN.get(inputFile));
            if (isUnimpacted) continue;
            impactfulFiles.add(inputFile);
            impactfulModulesFQNs.add(currFQN);
        }
        Set<String> impactedModulesFQN = DependencyGraph.from(importsByModule, allProjectFilesFQNs).impactedModules(impactfulModulesFQNs);
        this.mainFiles.stream().filter(f -> !impactedModulesFQN.contains(this.inputFileToFQN.get(f))).forEach(this.skippableFiles::add);
        this.testFiles.stream().filter(f -> f.status().equals((Object)InputFile.Status.SAME)).forEach(this.skippableFiles::add);
        LOG.info("Cached information of global symbols will be used for {} out of {} main files. Global symbols will be recomputed for the remaining files.", (Object)(this.mainFiles.size() - impactfulFiles.size()), (Object)this.mainFiles.size());
        LOG.info("Optimized analysis can be performed for {} out of {} files.", (Object)this.skippableFiles.size(), (Object)(this.mainFiles.size() + this.testFiles.size()));
        this.computeGlobalSymbols(impactfulFiles, context);
    }

    private boolean tryToUseCache(Map<String, Set<String>> importsByModule, InputFile inputFile, String currFQN) {
        Set<Descriptor> descriptors;
        if (!inputFile.status().equals((Object)InputFile.Status.SAME)) {
            return false;
        }
        Set<String> imports = this.caching.readImportMapEntry(inputFile.key());
        if (imports != null) {
            importsByModule.put(currFQN, imports);
        }
        if ((descriptors = this.caching.readProjectLevelSymbolTableEntry(inputFile.key())) != null && imports != null) {
            this.saveRetrievedDescriptors(inputFile.key(), descriptors, this.caching);
            return true;
        }
        return false;
    }

    private void saveRetrievedDescriptors(String fileKey, Set<Descriptor> descriptors, Caching caching) {
        this.projectLevelSymbolTable().insertEntry(fileKey, descriptors);
        caching.copyFromPrevious(fileKey);
    }

    public void computeGlobalSymbols(List<InputFile> files, SensorContext context) {
        PythonIndexer.GlobalSymbolsScanner globalSymbolsStep = new PythonIndexer.GlobalSymbolsScanner(this, context);
        globalSymbolsStep.execute(files, context);
        if (this.caching.isCacheEnabled()) {
            this.saveGlobalSymbolsInCache(files);
            this.saveMainFilesListInCache(new HashSet<String>(this.inputFileToFQN.values()));
        }
    }

    private void saveGlobalSymbolsInCache(List<InputFile> files) {
        for (InputFile inputFile : files) {
            String moduleFQN = this.inputFileToFQN.get(inputFile);
            Set<Descriptor> descriptors = this.projectLevelSymbolTable().descriptorsForModule(moduleFQN);
            Set<String> imports = this.projectLevelSymbolTable().importsByModule().get(moduleFQN);
            if (descriptors == null || imports == null) continue;
            this.caching.writeProjectLevelSymbolTableEntry(inputFile.key(), descriptors);
            this.caching.writeImportsMapEntry(inputFile.key(), imports);
        }
    }

    private Set<String> deletedModulesFQNs(Set<String> projectModulesFQNs) {
        Set<String> previousAnalysisModulesFQNs = this.caching.readFilesList();
        previousAnalysisModulesFQNs.removeAll(projectModulesFQNs);
        return previousAnalysisModulesFQNs;
    }

    private void saveMainFilesListInCache(Set<String> modulesFQN) {
        this.caching.writeFilesList(new ArrayList<String>(modulesFQN));
    }

    @Override
    public boolean canBeScannedWithoutParsing(InputFile inputFile) {
        return this.skippableFiles.contains(inputFile);
    }

    @Override
    public CacheContext cacheContext() {
        return this.caching.cacheContext();
    }
}

