/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.python.checks.cdk.AbstractIamPolicyStatementCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.PolicyStatement;

@Rule(key="S6317")
public class IamPrivilegeEscalationCheck
extends AbstractIamPolicyStatementCheck {
    private static final String ISSUE_MESSAGE_FORMAT = "This policy is vulnerable to the \"%s\" privilege escalation vector. Remove permissions or restrict the set of resources they apply to.";
    private static final String SECONDARY_MESSAGE = "Permissions are granted on all resources.";
    private static final Pattern SENSITIVE_RESOURCE_PATTERN = Pattern.compile("(^\\*$)|(arn:.*:(role|user|group)/\\*)");
    private static final Set<String> SENSITIVE_ACTIONS = Set.of("iam:CreatePolicyVersion", "iam:SetDefaultPolicyVersion", "iam:CreateAccessKey", "iam:CreateLoginProfile", "iam:UpdateLoginProfile", "iam:AttachUserPolicy", "iam:AttachGroupPolicy", "iam:AttachRolePolicy", "sts:AssumeRole", "iam:PutUserPolicy", "iam:PutGroupPolicy", "iam:PutRolePolicy", "iam:AddUserToGroup", "iam:UpdateAssumeRolePolicy", "iam:PassRole", "ec2:RunInstances", "lambda:CreateFunction", "lambda:InvokeFunction", "lambda:AddPermission", "lambda:CreateEventSourceMapping", "cloudformation:CreateStack", "datapipeline:CreatePipeline", "datapipeline:PutPipelineDefinition", "glue:CreateDevEndpoint", "glue:UpdateDevEndpoint", "lambda:UpdateFunctionCode");
    private static final Map<String, String> ATTACK_VECTOR_NAMES = Map.of("iam:CreatePolicyVersion", "Create Policy Version", "iam:SetDefaultPolicyVersion", "Set Default Policy Version", "iam:CreateAccessKey", "Create Access Key", "iam:CreateLoginProfile", "Create Login Profile", "iam:UpdateLoginProfile", "Update Login Profile ", "iam:AttachUserPolicy", "Attach User Policy", "iam:AttachGroupPolicy", "Attach Group Policy", "iam:AttachRolePolicy", "Attach Role Policy", "sts:AssumeRole", "Attach Role Policy");

    @Override
    protected void checkAllowingPolicyStatement(PolicyStatement policyStatement) {
        CdkUtils.ExpressionFlow actions = policyStatement.actions();
        CdkUtils.ExpressionFlow resources = policyStatement.resources();
        if (actions == null || resources == null || policyStatement.principals() != null || policyStatement.conditions() != null) {
            return;
        }
        CdkUtils.ExpressionFlow sensitiveAction = IamPrivilegeEscalationCheck.getSensitiveExpression(actions, CdkPredicate.isString(SENSITIVE_ACTIONS));
        CdkUtils.ExpressionFlow sensitiveResource = IamPrivilegeEscalationCheck.getSensitiveExpression(resources, CdkPredicate.matches(SENSITIVE_RESOURCE_PATTERN));
        if (sensitiveAction != null && sensitiveResource != null) {
            IamPrivilegeEscalationCheck.reportSensitiveActionAndResource(sensitiveAction, sensitiveResource);
        }
    }

    private static Optional<String> getAttackVectorName(CdkUtils.ExpressionFlow sensitiveAction) {
        return sensitiveAction.getExpression(CdkPredicate.isStringLiteral()).map(StringLiteral.class::cast).map(StringLiteral::trimmedQuotesValue).map(action -> ATTACK_VECTOR_NAMES.getOrDefault(action, null));
    }

    private static void reportSensitiveActionAndResource(CdkUtils.ExpressionFlow sensitiveAction, CdkUtils.ExpressionFlow resources) {
        String attackVectorName = IamPrivilegeEscalationCheck.getAttackVectorName(sensitiveAction).orElse("");
        String message = String.format(ISSUE_MESSAGE_FORMAT, attackVectorName);
        IssueLocation secondary = sensitiveAction.asSecondaryLocation(SECONDARY_MESSAGE);
        resources.addIssue(message, secondary);
    }
}

