//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// An NSURLResponse object represents a URL load response in a
    /// manner independent of protocol and URL scheme.
    ///
    ///
    /// NSURLResponse encapsulates the metadata associated
    /// with a URL load. Note that NSURLResponse objects do not contain
    /// the actual bytes representing the content of a URL. See
    /// NSURLConnection and NSURLConnectionDelegate for more information
    /// about receiving the content data for a URL load.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlresponse?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLResponse;
);

unsafe impl Send for NSURLResponse {}

unsafe impl Sync for NSURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSURLResponse {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSURLResponse {}

impl NSURLResponse {
    extern_methods!(
        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        /// Initialize an NSURLResponse with the provided values.
        ///
        /// Parameter `URL`: the URL
        ///
        /// Parameter `MIMEType`: the MIME content type of the response
        ///
        /// Parameter `length`: the expected content length of the associated data
        ///
        /// Parameter `name`: the name of the text encoding for the associated data, if applicable, else nil
        ///
        /// Returns: The initialized NSURLResponse.
        ///
        /// This is the designated initializer for NSURLResponse.
        #[unsafe(method(initWithURL:MIMEType:expectedContentLength:textEncodingName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithURL_MIMEType_expectedContentLength_textEncodingName(
            this: Allocated<Self>,
            url: &NSURL,
            mime_type: Option<&NSString>,
            length: NSInteger,
            name: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        /// Returns the URL of the receiver.
        ///
        /// Returns: The URL of the receiver.
        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub unsafe fn URL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        /// Returns the MIME type of the receiver.
        ///
        /// The MIME type is based on the information provided
        /// from an origin source. However, that value may be changed or
        /// corrected by a protocol implementation if it can be determined
        /// that the origin server or source reported the information
        /// incorrectly or imprecisely. An attempt to guess the MIME type may
        /// be made if the origin source did not report any such information.
        ///
        /// Returns: The MIME type of the receiver.
        #[unsafe(method(MIMEType))]
        #[unsafe(method_family = none)]
        pub unsafe fn MIMEType(&self) -> Option<Retained<NSString>>;

        /// Returns the expected content length of the receiver.
        ///
        /// Some protocol implementations report a content length
        /// as part of delivering load metadata, but not all protocols
        /// guarantee the amount of data that will be delivered in actuality.
        /// Hence, this method returns an expected amount. Clients should use
        /// this value as an advisory, and should be prepared to deal with
        /// either more or less data.
        ///
        /// Returns: The expected content length of the receiver, or -1 if
        /// there is no expectation that can be arrived at regarding expected
        /// content length.
        #[unsafe(method(expectedContentLength))]
        #[unsafe(method_family = none)]
        pub unsafe fn expectedContentLength(&self) -> c_longlong;

        #[cfg(feature = "NSString")]
        /// Returns the name of the text encoding of the receiver.
        ///
        /// This name will be the actual string reported by the
        /// origin source during the course of performing a protocol-specific
        /// URL load. Clients can inspect this string and convert it to an
        /// NSStringEncoding or CFStringEncoding using the methods and
        /// functions made available in the appropriate framework.
        ///
        /// Returns: The name of the text encoding of the receiver, or nil if no
        /// text encoding was specified.
        #[unsafe(method(textEncodingName))]
        #[unsafe(method_family = none)]
        pub unsafe fn textEncodingName(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Returns a suggested filename if the resource were saved to disk.
        ///
        /// The method first checks if the server has specified a filename using the
        /// content disposition header. If no valid filename is specified using that mechanism,
        /// this method checks the last path component of the URL. If no valid filename can be
        /// obtained using the last path component, this method uses the URL's host as the filename.
        /// If the URL's host can't be converted to a valid filename, the filename "unknown" is used.
        /// In most cases, this method appends the proper file extension based on the MIME type.
        /// This method always returns a valid filename.
        ///
        /// Returns: A suggested filename to use if saving the resource to disk.
        #[unsafe(method(suggestedFilename))]
        #[unsafe(method_family = none)]
        pub unsafe fn suggestedFilename(&self) -> Option<Retained<NSString>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLResponse {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// An NSHTTPURLResponse object represents a response to an
    /// HTTP URL load. It is a specialization of NSURLResponse which
    /// provides conveniences for accessing information specific to HTTP
    /// protocol responses.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nshttpurlresponse?language=objc)
    #[unsafe(super(NSURLResponse, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSHTTPURLResponse;
);

unsafe impl Send for NSHTTPURLResponse {}

unsafe impl Sync for NSHTTPURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSHTTPURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSHTTPURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSHTTPURLResponse {
    type Result = Self;
}

unsafe impl NSObjectProtocol for NSHTTPURLResponse {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSHTTPURLResponse {}

impl NSHTTPURLResponse {
    extern_methods!(
        #[cfg(all(feature = "NSDictionary", feature = "NSString", feature = "NSURL"))]
        /// initializer for NSHTTPURLResponse objects.
        ///
        /// Parameter `url`: the URL from which the response was generated.
        ///
        /// Parameter `statusCode`: an HTTP status code.
        ///
        /// Parameter `HTTPVersion`: The version of the HTTP response as represented by the server.  This is typically represented as "HTTP/1.1".
        ///
        /// Parameter `headerFields`: A dictionary representing the header keys and values of the server response.
        ///
        /// Returns: the instance of the object, or NULL if an error occurred during initialization.
        ///
        /// This API was introduced in Mac OS X 10.7.2 and iOS 5.0 and is not available prior to those releases.
        #[unsafe(method(initWithURL:statusCode:HTTPVersion:headerFields:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithURL_statusCode_HTTPVersion_headerFields(
            this: Allocated<Self>,
            url: &NSURL,
            status_code: NSInteger,
            http_version: Option<&NSString>,
            header_fields: Option<&NSDictionary<NSString, NSString>>,
        ) -> Option<Retained<Self>>;

        /// Returns the HTTP status code of the receiver.
        ///
        /// Returns: The HTTP status code of the receiver.
        #[unsafe(method(statusCode))]
        #[unsafe(method_family = none)]
        pub unsafe fn statusCode(&self) -> NSInteger;

        #[cfg(feature = "NSDictionary")]
        /// Returns a dictionary containing all the HTTP header fields
        /// of the receiver.
        ///
        /// By examining this header dictionary, clients can see
        /// the "raw" header information which was reported to the protocol
        /// implementation by the HTTP server. This may be of use to
        /// sophisticated or special-purpose HTTP clients.
        ///
        /// Returns: A dictionary containing all the HTTP header fields of the
        /// receiver.
        #[unsafe(method(allHeaderFields))]
        #[unsafe(method_family = none)]
        pub unsafe fn allHeaderFields(&self) -> Retained<NSDictionary>;

        #[cfg(feature = "NSString")]
        /// Returns the value which corresponds to the given header
        /// field. Note that, in keeping with the HTTP RFC, HTTP header field
        /// names are case-insensitive.
        ///
        /// Parameter `field`: the header field name to use for the lookup
        /// (case-insensitive).
        ///
        /// Returns: the value associated with the given header field, or nil if
        /// there is no value associated with the given header field.
        #[unsafe(method(valueForHTTPHeaderField:))]
        #[unsafe(method_family = none)]
        pub unsafe fn valueForHTTPHeaderField(
            &self,
            field: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Convenience method which returns a localized string
        /// corresponding to the status code for this response.
        ///
        /// Parameter `statusCode`: the status code to use to produce a localized string.
        ///
        /// Returns: A localized string corresponding to the given status code.
        #[unsafe(method(localizedStringForStatusCode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedStringForStatusCode(status_code: NSInteger) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSURLResponse`.
impl NSHTTPURLResponse {
    extern_methods!(
        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        /// Initialize an NSURLResponse with the provided values.
        ///
        /// Parameter `URL`: the URL
        ///
        /// Parameter `MIMEType`: the MIME content type of the response
        ///
        /// Parameter `length`: the expected content length of the associated data
        ///
        /// Parameter `name`: the name of the text encoding for the associated data, if applicable, else nil
        ///
        /// Returns: The initialized NSURLResponse.
        ///
        /// This is the designated initializer for NSURLResponse.
        #[unsafe(method(initWithURL:MIMEType:expectedContentLength:textEncodingName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithURL_MIMEType_expectedContentLength_textEncodingName(
            this: Allocated<Self>,
            url: &NSURL,
            mime_type: Option<&NSString>,
            length: NSInteger,
            name: Option<&NSString>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSHTTPURLResponse {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
