﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/codepipeline/model/WebhookDefinition.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/codepipeline/model/Tag.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodePipeline
{
namespace Model
{

  /**
   * <p>The detail returned for each webhook after listing webhooks, such as the
   * webhook URL, the webhook name, and the webhook ARN.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhookItem">AWS
   * API Reference</a></p>
   */
  class ListWebhookItem
  {
  public:
    AWS_CODEPIPELINE_API ListWebhookItem();
    AWS_CODEPIPELINE_API ListWebhookItem(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEPIPELINE_API ListWebhookItem& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEPIPELINE_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The detail returned for each webhook, such as the webhook authentication type
     * and filter rules.</p>
     */
    inline const WebhookDefinition& GetDefinition() const{ return m_definition; }

    /**
     * <p>The detail returned for each webhook, such as the webhook authentication type
     * and filter rules.</p>
     */
    inline bool DefinitionHasBeenSet() const { return m_definitionHasBeenSet; }

    /**
     * <p>The detail returned for each webhook, such as the webhook authentication type
     * and filter rules.</p>
     */
    inline void SetDefinition(const WebhookDefinition& value) { m_definitionHasBeenSet = true; m_definition = value; }

    /**
     * <p>The detail returned for each webhook, such as the webhook authentication type
     * and filter rules.</p>
     */
    inline void SetDefinition(WebhookDefinition&& value) { m_definitionHasBeenSet = true; m_definition = std::move(value); }

    /**
     * <p>The detail returned for each webhook, such as the webhook authentication type
     * and filter rules.</p>
     */
    inline ListWebhookItem& WithDefinition(const WebhookDefinition& value) { SetDefinition(value); return *this;}

    /**
     * <p>The detail returned for each webhook, such as the webhook authentication type
     * and filter rules.</p>
     */
    inline ListWebhookItem& WithDefinition(WebhookDefinition&& value) { SetDefinition(std::move(value)); return *this;}


    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline const Aws::String& GetUrl() const{ return m_url; }

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline bool UrlHasBeenSet() const { return m_urlHasBeenSet; }

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline void SetUrl(const Aws::String& value) { m_urlHasBeenSet = true; m_url = value; }

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline void SetUrl(Aws::String&& value) { m_urlHasBeenSet = true; m_url = std::move(value); }

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline void SetUrl(const char* value) { m_urlHasBeenSet = true; m_url.assign(value); }

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline ListWebhookItem& WithUrl(const Aws::String& value) { SetUrl(value); return *this;}

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline ListWebhookItem& WithUrl(Aws::String&& value) { SetUrl(std::move(value)); return *this;}

    /**
     * <p>A unique URL generated by CodePipeline. When a POST request is made to this
     * URL, the defined pipeline is started as long as the body of the post request
     * satisfies the defined authentication and filtering conditions. Deleting and
     * re-creating a webhook makes the old URL invalid and generates a new one.</p>
     */
    inline ListWebhookItem& WithUrl(const char* value) { SetUrl(value); return *this;}


    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline const Aws::String& GetErrorMessage() const{ return m_errorMessage; }

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline void SetErrorMessage(const Aws::String& value) { m_errorMessageHasBeenSet = true; m_errorMessage = value; }

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline void SetErrorMessage(Aws::String&& value) { m_errorMessageHasBeenSet = true; m_errorMessage = std::move(value); }

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline void SetErrorMessage(const char* value) { m_errorMessageHasBeenSet = true; m_errorMessage.assign(value); }

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline ListWebhookItem& WithErrorMessage(const Aws::String& value) { SetErrorMessage(value); return *this;}

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline ListWebhookItem& WithErrorMessage(Aws::String&& value) { SetErrorMessage(std::move(value)); return *this;}

    /**
     * <p>The text of the error message about the webhook.</p>
     */
    inline ListWebhookItem& WithErrorMessage(const char* value) { SetErrorMessage(value); return *this;}


    /**
     * <p>The number code of the error.</p>
     */
    inline const Aws::String& GetErrorCode() const{ return m_errorCode; }

    /**
     * <p>The number code of the error.</p>
     */
    inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }

    /**
     * <p>The number code of the error.</p>
     */
    inline void SetErrorCode(const Aws::String& value) { m_errorCodeHasBeenSet = true; m_errorCode = value; }

    /**
     * <p>The number code of the error.</p>
     */
    inline void SetErrorCode(Aws::String&& value) { m_errorCodeHasBeenSet = true; m_errorCode = std::move(value); }

    /**
     * <p>The number code of the error.</p>
     */
    inline void SetErrorCode(const char* value) { m_errorCodeHasBeenSet = true; m_errorCode.assign(value); }

    /**
     * <p>The number code of the error.</p>
     */
    inline ListWebhookItem& WithErrorCode(const Aws::String& value) { SetErrorCode(value); return *this;}

    /**
     * <p>The number code of the error.</p>
     */
    inline ListWebhookItem& WithErrorCode(Aws::String&& value) { SetErrorCode(std::move(value)); return *this;}

    /**
     * <p>The number code of the error.</p>
     */
    inline ListWebhookItem& WithErrorCode(const char* value) { SetErrorCode(value); return *this;}


    /**
     * <p>The date and time a webhook was last successfully triggered, in timestamp
     * format.</p>
     */
    inline const Aws::Utils::DateTime& GetLastTriggered() const{ return m_lastTriggered; }

    /**
     * <p>The date and time a webhook was last successfully triggered, in timestamp
     * format.</p>
     */
    inline bool LastTriggeredHasBeenSet() const { return m_lastTriggeredHasBeenSet; }

    /**
     * <p>The date and time a webhook was last successfully triggered, in timestamp
     * format.</p>
     */
    inline void SetLastTriggered(const Aws::Utils::DateTime& value) { m_lastTriggeredHasBeenSet = true; m_lastTriggered = value; }

    /**
     * <p>The date and time a webhook was last successfully triggered, in timestamp
     * format.</p>
     */
    inline void SetLastTriggered(Aws::Utils::DateTime&& value) { m_lastTriggeredHasBeenSet = true; m_lastTriggered = std::move(value); }

    /**
     * <p>The date and time a webhook was last successfully triggered, in timestamp
     * format.</p>
     */
    inline ListWebhookItem& WithLastTriggered(const Aws::Utils::DateTime& value) { SetLastTriggered(value); return *this;}

    /**
     * <p>The date and time a webhook was last successfully triggered, in timestamp
     * format.</p>
     */
    inline ListWebhookItem& WithLastTriggered(Aws::Utils::DateTime&& value) { SetLastTriggered(std::move(value)); return *this;}


    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline const Aws::String& GetArn() const{ return m_arn; }

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline void SetArn(const Aws::String& value) { m_arnHasBeenSet = true; m_arn = value; }

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline void SetArn(Aws::String&& value) { m_arnHasBeenSet = true; m_arn = std::move(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline void SetArn(const char* value) { m_arnHasBeenSet = true; m_arn.assign(value); }

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline ListWebhookItem& WithArn(const Aws::String& value) { SetArn(value); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline ListWebhookItem& WithArn(Aws::String&& value) { SetArn(std::move(value)); return *this;}

    /**
     * <p>The Amazon Resource Name (ARN) of the webhook.</p>
     */
    inline ListWebhookItem& WithArn(const char* value) { SetArn(value); return *this;}


    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline const Aws::Vector<Tag>& GetTags() const{ return m_tags; }

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline void SetTags(const Aws::Vector<Tag>& value) { m_tagsHasBeenSet = true; m_tags = value; }

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline void SetTags(Aws::Vector<Tag>&& value) { m_tagsHasBeenSet = true; m_tags = std::move(value); }

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline ListWebhookItem& WithTags(const Aws::Vector<Tag>& value) { SetTags(value); return *this;}

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline ListWebhookItem& WithTags(Aws::Vector<Tag>&& value) { SetTags(std::move(value)); return *this;}

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline ListWebhookItem& AddTags(const Tag& value) { m_tagsHasBeenSet = true; m_tags.push_back(value); return *this; }

    /**
     * <p>Specifies the tags applied to the webhook.</p>
     */
    inline ListWebhookItem& AddTags(Tag&& value) { m_tagsHasBeenSet = true; m_tags.push_back(std::move(value)); return *this; }

  private:

    WebhookDefinition m_definition;
    bool m_definitionHasBeenSet = false;

    Aws::String m_url;
    bool m_urlHasBeenSet = false;

    Aws::String m_errorMessage;
    bool m_errorMessageHasBeenSet = false;

    Aws::String m_errorCode;
    bool m_errorCodeHasBeenSet = false;

    Aws::Utils::DateTime m_lastTriggered;
    bool m_lastTriggeredHasBeenSet = false;

    Aws::String m_arn;
    bool m_arnHasBeenSet = false;

    Aws::Vector<Tag> m_tags;
    bool m_tagsHasBeenSet = false;
  };

} // namespace Model
} // namespace CodePipeline
} // namespace Aws
