import { TransportItemType } from '../../transports';
import { getCurrentTimestamp } from '../../utils';
import { defaultLogLevel, originalConsoleMethods } from './const';
export function initializeLogsAPI(transports, metas, tracesApi) {
    const pushLog = (args, { context, level } = {}) => {
        try {
            const item = {
                type: TransportItemType.LOG,
                payload: {
                    message: args
                        .map((arg) => {
                        try {
                            return String(arg);
                        }
                        catch (err) {
                            return '';
                        }
                    })
                        .join(' '),
                    level: level !== null && level !== void 0 ? level : defaultLogLevel,
                    context: context !== null && context !== void 0 ? context : {},
                    timestamp: getCurrentTimestamp(),
                    trace: tracesApi.getTraceContext(),
                },
                meta: metas.value,
            };
            transports.execute(item);
        }
        catch (err) {
            // TODO: Add proper logging when debug is enabled
        }
    };
    const callOriginalConsoleMethod = (level, ...args) => {
        originalConsoleMethods[level].apply(console, args);
    };
    return {
        callOriginalConsoleMethod,
        pushLog,
    };
}
//# sourceMappingURL=initialize.js.map