import * as metrics from '@opentelemetry/api-metrics';
import { AttributeHashMap } from './state/HashMap';
import { ObservableInstrument } from './Instruments';
import { InstrumentDescriptor } from '.';
/**
 * The class implements {@link metrics.ObservableResult} interface.
 */
export declare class ObservableResultImpl implements metrics.ObservableResult {
    private _descriptor;
    /**
     * @internal
     */
    _buffer: AttributeHashMap<number>;
    constructor(_descriptor: InstrumentDescriptor);
    /**
     * Observe a measurement of the value associated with the given attributes.
     */
    observe(value: number, attributes?: metrics.MetricAttributes): void;
}
/**
 * The class implements {@link metrics.BatchObservableCallback} interface.
 */
export declare class BatchObservableResultImpl implements metrics.BatchObservableResult {
    /**
     * @internal
     */
    _buffer: Map<ObservableInstrument, AttributeHashMap<number>>;
    /**
     * Observe a measurement of the value associated with the given attributes.
     */
    observe(metric: metrics.Observable, value: number, attributes?: metrics.MetricAttributes): void;
}
//# sourceMappingURL=ObservableResult.d.ts.map